/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FordiacResourceChangeListener
implements IResourceChangeListener {
    private static final String XML_FILE_EXTENSION = "xml";
    private SystemManager systemManager;
    private Set<String> systemImportWatingList = Collections.synchronizedSet(new HashSet());

    public FordiacResourceChangeListener(SystemManager systemManager) {
        this.systemManager = systemManager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    block0 : switch (delta.getKind()) {
                        case 4: {
                            if (16384 != delta.getFlags()) break;
                            if (delta.getAffectedChildren(1).length != 0) {
                                FordiacResourceChangeListener.this.loadSystem(delta.getResource().getProject());
                            } else if (delta.getAffectedChildren(2).length != 0) {
                                FordiacResourceChangeListener.this.handleProjectRemove(delta);
                                return false;
                            }
                            return false;
                        }
                        case 2: {
                            if (delta.getFlags() == 8192) {
                                return false;
                            }
                            switch (delta.getResource().getType()) {
                                case 1: {
                                    FordiacResourceChangeListener.this.handleFileDelete(delta);
                                    break block0;
                                }
                                case 4: {
                                    FordiacResourceChangeListener.this.handleProjectRemove(delta);
                                    return false;
                                }
                            }
                            break;
                        }
                        case 1: {
                            if (4096 == (delta.getFlags() & 0x1000)) {
                                switch (delta.getResource().getType()) {
                                    case 1: {
                                        FordiacResourceChangeListener.this.handleFileMove(delta);
                                        return false;
                                    }
                                    case 4: {
                                        FordiacResourceChangeListener.this.handleProjectRename(delta);
                                        break;
                                    }
                                }
                                return true;
                            }
                            String projectName = delta.getResource().getProject().getName();
                            AutomationSystem system = FordiacResourceChangeListener.this.systemManager.getSystemForName(projectName);
                            if (system == null && !"Tool Library".equals(projectName)) {
                                FordiacResourceChangeListener.this.loadSystem(delta.getResource().getProject());
                            }
                            if (system != null || projectName.equals("Tool Library")) {
                                switch (delta.getResource().getType()) {
                                    case 1: {
                                        FordiacResourceChangeListener.this.handleFileCopy(delta);
                                        break;
                                    }
                                    case 2: {
                                        return true;
                                    }
                                }
                                return false;
                            }
                            if (1 != delta.getResource().getType()) break;
                            FordiacResourceChangeListener.this.handledCopiedProjectFiles(delta);
                        }
                    }
                    return true;
                }
            };
            try {
                rootDelta.accept(visitor);
            }
            catch (CoreException coreException) {}
        }
    }

    protected void handleFileDelete(IResourceDelta delta) {
        Palette palette = this.systemManager.getPalette(delta.getResource().getProject());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)file, (Palette)palette);
        if (entry != null) {
            FordiacResourceChangeListener.closeAllFBTypeEditor(entry);
            palette.removePaletteEntry(entry);
        }
    }

    protected void handleFileCopy(IResourceDelta delta) {
        PaletteEntry entry;
        IFile file;
        Palette dstPalette = this.systemManager.getPalette(delta.getResource().getProject());
        if (!TypeLibrary.paletteContainsType((Palette)dstPalette, (IFile)(file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath()))) && (entry = TypeLibrary.createPaleteEntry((Palette)dstPalette, (IFile)file)) != null) {
            FordiacResourceChangeListener.updatePaletteEntry(file, entry);
        }
    }

    protected void handledCopiedProjectFiles(IResourceDelta delta) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        if (file != null && file.getFileExtension() != null && XML_FILE_EXTENSION.equalsIgnoreCase(file.getFileExtension())) {
            this.handleSystemFileCopy(file);
        }
    }

    protected void handleSystemFileCopy(final IFile file) {
        try {
            Scanner scanner = new Scanner(file.getContents());
            if (scanner.findWithinHorizon("<libraryElement:AutomationSystem", 0) != null) {
                final IProject project = file.getProject();
                if (!file.getName().equals(String.valueOf(file.getProject().getName()) + ".xml")) {
                    WorkspaceJob job = new WorkspaceJob("Renaming system file"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            IPath path = file.getProjectRelativePath();
                            path = path.removeLastSegments(1);
                            path = path.append(String.valueOf(project.getName()) + ".sys");
                            try {
                                file.move(path, true, null);
                                FordiacResourceChangeListener.this.systemManager.loadProject(project);
                            }
                            catch (Exception e) {
                                Activator.getDefault().logError(e.getMessage(), e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setRule((ISchedulingRule)project);
                    job.schedule();
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void handleFileMove(IResourceDelta delta) {
        AutomationSystem system;
        IFile src = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
        if (src.getParent().equals((Object)delta.getResource().getParent())) {
            this.handleFileRename(delta, src);
        }
        if ((system = this.systemManager.getSystemForName(src.getProject().getName())) != null) {
            WorkspaceJob job = new WorkspaceJob("Save system: " + system.getName() + " after type movement"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    SystemManager.INSTANCE.saveSystem(system);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)src.getProject());
            job.schedule();
        }
    }

    private void handleFileRename(IResourceDelta delta, IFile src) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getResource().getFullPath());
        Palette dstPalette = this.systemManager.getPalette(file.getProject());
        PaletteEntry entry = TypeLibrary.getPaletteEntryForFile((IFile)src, (Palette)dstPalette);
        FordiacResourceChangeListener.updatePaletteEntry(file, entry);
    }

    private static void updatePaletteEntry(IFile newFile, final PaletteEntry entry) {
        if (entry != null) {
            final String newTypeName = TypeLibrary.getTypeNameFromFile((IFile)newFile);
            entry.setLabel(newTypeName);
            entry.setFile(newFile);
            WorkspaceJob job = new WorkspaceJob("Save Renamed type: " + entry.getLabel()){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    LibraryElement type = entry.getType();
                    if (type != null && !newTypeName.equals(type.getName())) {
                        type.setName(newTypeName);
                        AbstractTypeExporter.saveType((PaletteEntry)entry);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)newFile.getProject());
            job.schedule();
        }
    }

    private void loadSystem(final IProject project) {
        final String projectName = project.getName();
        if (!this.systemImportWatingList.contains(projectName)) {
            this.systemImportWatingList.add(projectName);
            WorkspaceJob job = new WorkspaceJob("Load system: " + projectName){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    AutomationSystem system = FordiacResourceChangeListener.this.systemManager.loadProject(project);
                    if (system != null && !system.getName().equals(projectName)) {
                        FordiacResourceChangeListener.renameSystem(system, project);
                    }
                    FordiacResourceChangeListener.this.systemManager.notifyListeners();
                    FordiacResourceChangeListener.this.systemImportWatingList.remove(projectName);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)project);
            job.schedule();
        }
    }

    private void handleProjectRename(IResourceDelta delta) {
        IPath srcPath = delta.getMovedFromPath();
        if (srcPath != null) {
            IProject src = ResourcesPlugin.getWorkspace().getRoot().getProject(srcPath.lastSegment());
            AutomationSystem system = this.systemManager.getSystemForName(src.getName());
            IProject project = delta.getResource().getProject();
            if (system != null) {
                FordiacResourceChangeListener.renameSystem(system, project);
            }
        }
    }

    protected static void renameSystem(final AutomationSystem system, IProject project) {
        final IFile oldSystemFile = project.getFile(String.valueOf(system.getName()) + ".sys");
        String newProjectName = project.getName();
        system.setName(newProjectName);
        system.setProject(project);
        WorkspaceJob job = new WorkspaceJob("Save system configuration: " + newProjectName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    oldSystemFile.delete(true, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
                SystemManager.INSTANCE.saveSystem(system);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    protected void handleProjectRemove(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        AutomationSystem system = this.systemManager.getSystemForName(project.getName());
        if (system != null) {
            FordiacResourceChangeListener.closeAllEditors(system);
            this.systemManager.removeSystem(system);
        }
    }

    private static void closeAllEditors(final AutomationSystem refSystem) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorUtils.closeEditorsFiltered(editor -> editor instanceof ISystemEditor && refSystem.equals(((ISystemEditor)editor).getSystem()));
            }
        });
    }

    private static void closeAllFBTypeEditor(final PaletteEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IFile file = entry.getFile();
                EditorUtils.closeEditorsFiltered(editor -> {
                    IEditorInput input = editor.getEditorInput();
                    return input instanceof FileEditorInput && file.equals((Object)((FileEditorInput)input).getFile());
                });
            }
        });
    }
}

