/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.handlers;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.CyclomaticComplexity;
import org.eclipse.fordiac.ide.metrics.analyzers.HalsteadMetric;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CalculateCodeMetrics
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<MetricData> result = new ArrayList<MetricData>();
        INamedElement selectedElement = CalculateCodeMetrics.getSelectedElement((StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (selectedElement != null) {
            CalculateCodeMetrics.calculateMetrics(selectedElement, result);
            CalculateCodeMetrics.displayResults(selectedElement, result, HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event));
        }
        return null;
    }

    private static INamedElement getSelectedElement(StructuredSelection currentSelection) {
        Object obj = currentSelection.getFirstElement();
        if (obj instanceof IFile) {
            return CalculateCodeMetrics.checkSelectedFile((IFile)obj);
        }
        return obj instanceof INamedElement ? (INamedElement)obj : null;
    }

    private static INamedElement checkSelectedFile(IFile file) {
        PaletteEntry entry = FBTypeUtils.getPaletteEntryForFile((IFile)file);
        if (entry instanceof FBTypePaletteEntry) {
            return ((FBTypePaletteEntry)entry).getFBType();
        }
        return null;
    }

    private static void calculateMetrics(INamedElement element, List<MetricData> result) {
        List<AbstractCodeMetricAnalyzer> analyzers = CalculateCodeMetrics.getAnalyzers();
        for (AbstractCodeMetricAnalyzer analyzer : analyzers) {
            analyzer.calculateMetrics(element);
            result.addAll(analyzer.getResults());
        }
    }

    private static List<AbstractCodeMetricAnalyzer> getAnalyzers() {
        ArrayList<AbstractCodeMetricAnalyzer> analyzers = new ArrayList<AbstractCodeMetricAnalyzer>();
        analyzers.add(new CyclomaticComplexity());
        analyzers.add(new HalsteadMetric());
        return analyzers;
    }

    private static void displayResults(INamedElement element, List<MetricData> result, IWorkbenchWindow workbenchWindow) {
        MetricsResultDialog resultDialog = new MetricsResultDialog(workbenchWindow.getShell(), element, result);
        resultDialog.open();
    }

    private static class MetricsResultDialog
    extends MessageDialog {
        private final List<MetricData> data;

        public MetricsResultDialog(Shell parent, INamedElement element, List<MetricData> data) {
            super(parent, "Calculated Metrics for " + element.getName(), null, null, 2, 0, new String[]{IDialogConstants.OK_LABEL});
            this.data = data;
        }

        protected Control createMessageArea(Composite composite) {
            Composite body = (Composite)super.createMessageArea(composite);
            TableViewer viewer = new TableViewer(body, 2818);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)viewer.getTable());
            MetricsResultDialog.configureTableColumns(viewer.getTable());
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new MetricsResultLabelProvider());
            viewer.setInput(this.data);
            return body;
        }

        private static void configureTableColumns(Table table) {
            new TableColumn(table, 16384).setText("Metric");
            new TableColumn(table, 131072).setText("Value");
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, 100));
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 10));
            table.setLayout((Layout)layout);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
        }
    }

    public static class MetricsResultLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final DecimalFormat decimalFormat = new DecimalFormat("#0.00");

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MetricData) {
                switch (columnIndex) {
                    case 0: {
                        return ((MetricData)element).getName();
                    }
                    case 1: {
                        return decimalFormat.format(((MetricData)element).getValue());
                    }
                }
            }
            return element.toString();
        }
    }
}

