/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte1_0_x;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.utils.CompareEditorOpenerUtil;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.util.Utils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CPPExportFilter
implements IExportFilter {
    protected Element docel;
    protected String destDir;
    protected PrintWriter pwCPP;
    protected PrintWriter pwH;
    protected String name;
    private Map<String, VarDefinition> vars = new HashMap<String, VarDefinition>();
    protected int dataInCount;
    protected int dataOutCount;
    protected int internalCount;
    protected int fBCount;
    protected List<String> inputVars = new ArrayList<String>();
    protected List<String> outputVars = new ArrayList<String>();
    protected List<VarDefinition> internalVars = new ArrayList<VarDefinition>();
    protected List<FBDefinition> funtionBlocks = new ArrayList<FBDefinition>();
    protected Set<String> internal2InterfaceEventConns = new HashSet<String>();
    protected List<Element> eventConn = new ArrayList<Element>();
    protected Set<String> eventConnHash = new HashSet<String>();
    protected List<Element> dataConn = new ArrayList<Element>();
    protected Set<String> dataConnHash = new HashSet<String>();
    protected Set<String> interface2InternalDataConns = new HashSet<String>();
    protected Set<String> internal2InterfaceDataConns = new HashSet<String>();
    protected List<String> forteEmitterErrors = new ArrayList<String>();
    protected List<String> forteEmitterWarnings = new ArrayList<String>();
    protected List<String> forteEmitterInfos = new ArrayList<String>();
    protected LibraryElement libraryType;

    public Map<String, VarDefinition> getVars() {
        return this.vars;
    }

    public static void convertToLibraryElement2(Element docel) {
        NodeList evts = docel.getElementsByTagName("Event");
        int i = 0;
        while (i < evts.getLength()) {
            Element el = (Element)evts.item(i);
            if (el.getAttribute("Type").equals("EVENT")) {
                el.setAttribute("Type", "");
            }
            ++i;
        }
        NodeList eihdr = docel.getElementsByTagName("EventInputs");
        if (eihdr.getLength() < 1) {
            return;
        }
        NodeList eis = ((Element)eihdr.item(0)).getElementsByTagName("Event");
        String[] einames = new String[eis.getLength()];
        int j = 0;
        while (j < einames.length) {
            einames[j] = ((Element)eis.item(j)).getAttribute("Name");
            ++j;
        }
        NodeList nodes = docel.getElementsByTagName("ECTransition");
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Element tran = (Element)nodes.item(i2);
            String cond = tran.getAttribute("Condition").trim();
            if (cond.length() < 1) break;
            tran.removeAttribute("Condition");
            String einame = cond;
            int n = einame.indexOf(32);
            if (n > 0) {
                einame = einame.substring(0, n);
            }
            if ((n = einame.indexOf(38)) > 0) {
                einame = einame.substring(0, n);
            }
            int j2 = 0;
            while (j2 < einames.length) {
                if (einame.equals(einames[j2])) {
                    tran.setAttribute("Event", einame);
                    break;
                }
                ++j2;
            }
            if (tran.getAttribute("Event").length() > 0) {
                if ((cond = cond.substring(einame.length()).trim()).startsWith("&")) {
                    cond = cond.substring(1);
                } else if (cond.startsWith("AND ")) {
                    cond = cond.substring(4);
                }
            }
            if ((cond = cond.trim()).length() > 0) {
                tran.setAttribute("Guard", cond);
            }
            ++i2;
        }
    }

    public CPPExportFilter() {
    }

    public CPPExportFilter(Document doc, String destDir) {
        Document document = doc;
        this.docel = document.getDocumentElement();
        CPPExportFilter.convertToLibraryElement2(this.docel);
        this.destDir = destDir;
        this.name = this.docel.getAttribute("Name");
    }

    public void export(IFile typeFile, String destination, boolean forceOverwrite, LibraryElement type) throws ExportException {
        this.libraryType = type;
        this.export(typeFile, destination, forceOverwrite);
    }

    public void startExport(boolean overwrite) {
        this.vars = new HashMap<String, VarDefinition>();
        this.dataInCount = 0;
        this.dataOutCount = 0;
        this.internalCount = 0;
        this.fBCount = 0;
        this.inputVars = new ArrayList<String>();
        this.outputVars = new ArrayList<String>();
        this.internalVars = new ArrayList<VarDefinition>();
        this.funtionBlocks = new ArrayList<FBDefinition>();
        this.internal2InterfaceEventConns = new HashSet<String>();
        this.eventConn = new ArrayList<Element>();
        this.eventConnHash = new HashSet<String>();
        this.dataConn = new ArrayList<Element>();
        this.dataConnHash = new HashSet<String>();
        this.interface2InternalDataConns = new HashSet<String>();
        this.internal2InterfaceDataConns = new HashSet<String>();
        String name = this.docel.getAttribute("Name");
        if (this.destDir != null) {
            String fName = String.valueOf(this.destDir) + File.separatorChar + name;
            try {
                File f = new File(String.valueOf(fName) + ".cpp");
                File h = new File(String.valueOf(fName) + ".h");
                if (!overwrite && (f.exists() || h.exists())) {
                    ICompareEditorOpener opener = CompareEditorOpenerUtil.getOpener();
                    String msg = MessageFormat.format("Overwrite " + name + ".cpp" + " and " + name + ".h. " + (opener != null ? "\nMerge will create a backup of the original File and open an editor to merge the files manually!" : ""), f.getAbsolutePath());
                    MessageDialog msgDiag = new MessageDialog(Display.getDefault().getActiveShell(), "File Exists", null, msg, 6, new String[]{JFaceResources.getString((String)"yes"), "Merge", JFaceResources.getString((String)"cancel")}, 0);
                    int res = msgDiag.open();
                    switch (res) {
                        case 0: {
                            this.pwCPP = new PrintWriter(new FileOutputStream(String.valueOf(fName) + ".cpp"));
                            this.pwH = new PrintWriter(new FileOutputStream(String.valueOf(fName) + ".h"));
                            this.export();
                            this.pwCPP.close();
                            this.pwH.close();
                            break;
                        }
                        case 1: {
                            this.performManualMerge(name, fName, f, h, opener);
                            break;
                        }
                    }
                } else {
                    this.pwCPP = new PrintWriter(new FileOutputStream(String.valueOf(fName) + ".cpp"));
                    this.pwH = new PrintWriter(new FileOutputStream(String.valueOf(fName) + ".h"));
                    this.export();
                    this.pwCPP.close();
                    this.pwH.close();
                }
            }
            catch (IOException e) {
                this.forteEmitterErrors.add(" - " + fName + " " + e.getMessage());
            }
        }
    }

    private void performManualMerge(String name, String fName, File f, File h, ICompareEditorOpener opener) throws IOException {
        if (opener != null) {
            boolean diffs = false;
            File originalCpp = Utils.createBakFile((File)f);
            File originalH = Utils.createBakFile((File)h);
            File tempcpp = new File(String.valueOf(fName) + ".cpp");
            File temph = new File(String.valueOf(fName) + ".h");
            this.pwCPP = new PrintWriter(new FileOutputStream(tempcpp));
            this.pwH = new PrintWriter(new FileOutputStream(temph));
            this.export();
            this.pwCPP.close();
            this.pwH.close();
            opener.setName(name);
            opener.setTitle(String.valueOf(name) + ".cpp");
            opener.setNewFile(tempcpp);
            opener.setOriginalFile(originalCpp);
            if (opener.hasDifferences()) {
                opener.openCompareEditor();
                diffs = true;
            }
            opener.setTitle(String.valueOf(name) + ".h");
            opener.setNewFile(temph);
            opener.setOriginalFile(originalH);
            if (opener.hasDifferences()) {
                opener.openCompareEditor();
                diffs = true;
            }
            if (!diffs) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No Differences", (String)"There where no differences between the orignal file and the newly generated one!");
            }
        }
    }

    private void export() {
        this.exportHeader();
        String type = this.docel.getTagName();
        if (type.equals("ResourceType")) {
            this.exportRES();
        } else if (type.equals("DeviceType")) {
            this.exportDevice();
        } else if (type.equals("FBType") || type.equals("AdapterType")) {
            this.exportFB();
        }
        this.exportClosingCode();
    }

    private void exportRES() {
        this.exportResStarter();
        this.exportResConstructor();
    }

    private void exportDevice() {
        this.exportDeviceStarter();
        this.exportDeviceConstructor();
    }

    private void exportFB() {
        Element el;
        Node node;
        this.exportFBStarter();
        NodeList l1 = this.docel.getElementsByTagName("InterfaceList");
        if (l1.getLength() != 0 && (node = l1.item(0)) instanceof Element) {
            el = (Element)node;
            this.exportFBInterface();
        }
        if (this.docel.getElementsByTagName("BasicFB").getLength() != 0) {
            l1 = this.docel.getElementsByTagName("BasicFB");
            node = l1.item(0);
            if (node instanceof Element) {
                el = (Element)node;
                this.exportBasicFB(el.getChildNodes());
            }
        } else if (this.docel.getElementsByTagName("FBNetwork").getLength() != 0) {
            l1 = this.docel.getElementsByTagName("FBNetwork");
            node = l1.item(0);
            if (node instanceof Element) {
                el = (Element)node;
                this.exportFBNetwork(el.getChildNodes());
            }
        } else if (this.docel.getElementsByTagName("SimpleFB").getLength() != 0) {
            l1 = this.docel.getElementsByTagName("SimpleFB");
            node = l1.item(0);
            if (node instanceof Element) {
                el = (Element)node;
                this.exportSimpleFB(el.getChildNodes());
            }
        } else if (this.libraryType instanceof FBType) {
            this.exportSIFBExecuteEvent();
        }
        this.exportFBConstructor();
    }

    private void exportFBInterface() {
        Node node;
        NodeList l1 = this.docel.getElementsByTagName("InputVars");
        if (l1.getLength() != 0) {
            node = l1.item(0);
            this.exportVarInputs((Element)node);
        }
        if ((l1 = this.docel.getElementsByTagName("OutputVars")).getLength() != 0) {
            node = l1.item(0);
            this.exportVarOutputs((Element)node);
        }
        if ((l1 = this.docel.getElementsByTagName("EventInputs")).getLength() != 0) {
            node = l1.item(0);
            this.exportEvents("EventInput", ((Element)node).getChildNodes(), this.inputVars);
        }
        if ((l1 = this.docel.getElementsByTagName("EventOutputs")).getLength() != 0) {
            node = l1.item(0);
            this.exportEvents("EventOutput", ((Element)node).getChildNodes(), this.outputVars);
        } else {
            this.handleNotPresentEOTag();
        }
        l1 = this.docel.getElementsByTagName("InternalVars");
        if (l1.getLength() != 0) {
            node = l1.item(0);
            this.exportVarInternals((Element)node);
        }
        this.exportFBInterfaceSpec();
    }

    private void exportFBNetworkConnections() {
        Element el;
        int i;
        NodeList conns;
        Node node;
        this.eventConn.clear();
        this.eventConnHash.clear();
        this.dataConn.clear();
        this.dataConnHash.clear();
        NodeList l1 = this.docel.getElementsByTagName("EventConnections");
        if (l1.getLength() > 0) {
            node = l1.item(0);
            conns = node.getChildNodes();
            i = 0;
            while (i < conns.getLength()) {
                node = conns.item(i);
                if (node instanceof Element && (el = (Element)node).getNodeName().equals("Connection")) {
                    this.eventConn.add(el);
                    if (-1 == el.getAttribute("Destination").indexOf(46)) {
                        this.internal2InterfaceEventConns.add(el.getAttribute("Source"));
                    } else {
                        this.eventConnHash.add(el.getAttribute("Source"));
                    }
                }
                ++i;
            }
            this.exportEC();
        }
        if ((l1 = this.docel.getElementsByTagName("DataConnections")).getLength() > 0) {
            node = l1.item(0);
            conns = node.getChildNodes();
            i = 0;
            while (i < conns.getLength()) {
                node = conns.item(i);
                if (node instanceof Element && (el = (Element)node).getNodeName().equals("Connection")) {
                    this.dataConn.add(el);
                    if (-1 == el.getAttribute("Source").indexOf(46)) {
                        this.interface2InternalDataConns.add(el.getAttribute("Source"));
                    } else if (-1 == el.getAttribute("Destination").indexOf(46)) {
                        this.internal2InterfaceDataConns.add(el.getAttribute("Source"));
                    } else {
                        this.dataConnHash.add(el.getAttribute("Source"));
                    }
                }
                ++i;
            }
            this.exportDC();
        }
        this.exportFBNetworkInternalInterface();
    }

    private void exportBasicFB(NodeList basicFBNodes) {
        Element eccNode = null;
        int len = basicFBNodes.getLength();
        int i = 0;
        while (i < len) {
            Node node = basicFBNodes.item(i);
            if (node instanceof Element) {
                Element el = (Element)node;
                if (el.getNodeName().equals("ECC")) {
                    eccNode = el;
                } else if (el.getNodeName().equals("Algorithm")) {
                    NodeList nodes = el.getChildNodes();
                    int alglen = nodes.getLength();
                    int ii = 0;
                    while (ii < alglen) {
                        Node node2 = nodes.item(ii);
                        if (node2 instanceof Element) {
                            this.exportAlgorithm(el.getAttribute("Name"), ((Element)node2).getNodeName(), ((Element)node2).getAttribute("Text"));
                        }
                        ++ii;
                    }
                }
            }
            ++i;
        }
        if (eccNode != null) {
            this.exportECC(eccNode);
        }
    }

    private void exportSimpleFB(NodeList simpleFBNodes) {
        int len = simpleFBNodes.getLength();
        int i = 0;
        while (i < len) {
            Element el;
            Node node = simpleFBNodes.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("Algorithm")) {
                NodeList nodes = el.getChildNodes();
                int alglen = nodes.getLength();
                int ii = 0;
                while (ii < alglen) {
                    Node node2 = nodes.item(ii);
                    if (node2 instanceof Element) {
                        this.exportAlgorithm(el.getAttribute("Name"), ((Element)node2).getNodeName(), ((Element)node2).getAttribute("Text"));
                    }
                    ++ii;
                }
            }
            ++i;
        }
    }

    private void exportFBNetwork(NodeList fbnNodes) {
        int len = fbnNodes.getLength();
        this.fBCount = 0;
        this.funtionBlocks.clear();
        int i = 0;
        while (i < len) {
            Element el;
            Node node = fbnNodes.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("FB")) {
                ++this.fBCount;
                FBDefinition newFBDef = new FBDefinition();
                newFBDef.type = el.getAttribute("Type");
                newFBDef.name = el.getAttribute("Name");
                NodeList parameterNodes = el.getChildNodes();
                ArrayList<String> paramNames = new ArrayList<String>();
                ArrayList<String> paramValues = new ArrayList<String>();
                int j = 0;
                while (j < parameterNodes.getLength()) {
                    Node nodeParam = parameterNodes.item(j);
                    if (nodeParam instanceof Element) {
                        Element parameter = (Element)nodeParam;
                        paramNames.add(parameter.getAttribute("Name"));
                        paramValues.add(parameter.getAttribute("Value"));
                    }
                    ++j;
                }
                newFBDef.paramName = paramNames.toArray(new String[paramNames.size()]);
                newFBDef.paramValue = paramValues.toArray(new String[paramNames.size()]);
                this.funtionBlocks.add(newFBDef);
            }
            ++i;
        }
        this.exportFBVar();
        this.exportFBNetworkConnections();
        this.exportCompFBExecuteEventMethod();
    }

    protected void exportVarInputs(Element varInputs) {
        this.exportVarNameArrays("DataInput", varInputs.getChildNodes());
        NodeList l1 = varInputs.getChildNodes();
        int len = l1.getLength();
        this.dataInCount = 0;
        int i = 0;
        while (i < len) {
            Element el;
            Node node = l1.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("VarDeclaration")) {
                VarDefinition newVarDef = new VarDefinition(el, this.dataInCount, 0);
                this.inputVars.add(newVarDef.name);
                this.vars.put(newVarDef.name, newVarDef);
                this.exportVariable(newVarDef);
                ++this.dataInCount;
            }
            ++i;
        }
    }

    private void exportVarOutputs(Element varOutputs) {
        this.exportVarNameArrays("DataOutput", varOutputs.getChildNodes());
        NodeList l1 = varOutputs.getChildNodes();
        int len = l1.getLength();
        this.dataOutCount = 0;
        int i = 0;
        while (i < len) {
            Element el;
            Node node = l1.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("VarDeclaration")) {
                VarDefinition newVarDef = new VarDefinition(el, this.dataOutCount, 1);
                this.outputVars.add(newVarDef.name);
                this.vars.put(newVarDef.name, newVarDef);
                this.exportVariable(newVarDef);
                ++this.dataOutCount;
            }
            ++i;
        }
    }

    private void exportVarInternals(Element varInternals) {
        this.exportVarNameArrays("Internals", varInternals.getChildNodes());
        NodeList l1 = varInternals.getChildNodes();
        int len = l1.getLength();
        this.internalCount = 0;
        int i = 0;
        while (i < len) {
            Element el;
            Node node = l1.item(i);
            if (node instanceof Element && (el = (Element)node).getNodeName().equals("VarDeclaration")) {
                VarDefinition newVarDef = new VarDefinition(el, this.internalCount, 2);
                this.internalVars.add(newVarDef);
                this.vars.put(newVarDef.name, newVarDef);
                this.exportVariable(newVarDef);
                ++this.internalCount;
            }
            ++i;
        }
    }

    protected abstract void exportHeader();

    protected abstract void exportFBStarter();

    protected abstract void exportCompFBExecuteEventMethod();

    protected abstract void exportSIFBExecuteEvent();

    protected abstract void exportFBNetworkInternalInterface();

    protected abstract void exportFBConstructor();

    protected abstract void exportFBManagedObjectMethods();

    protected abstract void exportResStarter();

    protected abstract void exportResConstructor();

    protected abstract void exportDeviceStarter();

    protected abstract void exportDeviceConstructor();

    protected abstract void exportClosingCode();

    protected abstract void exportVarNameArrays(String var1, NodeList var2);

    protected abstract void exportEvents(String var1, NodeList var2, List<String> var3);

    protected abstract void exportAlgorithm(String var1, String var2, String var3);

    protected abstract void exportVariable(VarDefinition var1);

    protected abstract void exportFBVar();

    protected abstract void exportEC();

    protected abstract void exportDC();

    protected abstract void exportECC(Element var1);

    protected abstract void exportFBInterfaceSpec();

    protected abstract void handleNotPresentEOTag();

    public static String trimSTRING(String value) {
        if (value.startsWith("\"") || value.startsWith("'")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"") || value.endsWith("'")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public List<String> getErrors() {
        return this.forteEmitterErrors;
    }

    public List<String> getWarnings() {
        return this.forteEmitterWarnings;
    }

    public List<String> getInfos() {
        return this.forteEmitterInfos;
    }

    protected static class FBDefinition {
        private String name;
        private String type;
        private String[] paramName;
        private String[] paramValue;

        protected FBDefinition() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String[] getParamName() {
            return this.paramName;
        }

        public void setParamName(String[] paramName) {
            this.paramName = paramName;
        }

        public String[] getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(String[] paramValue) {
            this.paramValue = paramValue;
        }
    }

    public static class VarDefinition {
        private String name;
        private String type;
        private int arraySizeValue;
        private String initialValue;
        private int count;
        private int inOutInternal;

        public VarDefinition(Element el, int count, int inoutinternal) {
            this.name = el.getAttribute("Name");
            this.type = el.getAttribute("Type");
            String arraySize = el.getAttribute("ArraySize");
            int val = 0;
            if (arraySize != null && !"".equals(arraySize)) {
                val = Integer.parseInt(arraySize);
            }
            this.arraySizeValue = val;
            this.initialValue = el.getAttribute("InitialValue");
            this.count = count;
            this.inOutInternal = inoutinternal;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getArraySizeValue() {
            return this.arraySizeValue;
        }

        public void setArraySizeValue(int arraySizeValue) {
            this.arraySizeValue = arraySizeValue;
        }

        public String getInitialValue() {
            return this.initialValue;
        }

        public void setInitialValue(String initialValue) {
            this.initialValue = initialValue;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getInOutInternal() {
            return this.inOutInternal;
        }

        public void setInOutInternal(int inOutInternal) {
            this.inOutInternal = inOutInternal;
        }
    }
}

