/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.export.Activator;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.ExportFilter;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.export.IExportTemplate;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.CompareEditorOpenerUtil;
import org.eclipse.fordiac.ide.export.utils.DelayedFiles;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class TemplateExportFilter
extends ExportFilter {
    private List<String> reformat(LibraryElement type, List<String> messages) {
        return messages.stream().map(v -> type != null ? String.valueOf(type.getName()) + ": " + v : v).collect(Collectors.toList());
    }

    @Override
    public final void export(IFile typeFile, String destination, boolean forceOverwrite) throws ExportException {
        this.export(typeFile, destination, forceOverwrite, null);
    }

    @Override
    public void export(IFile typeFile, String destination, boolean forceOverwrite, LibraryElement type) throws ExportException {
        try {
            boolean overwrite;
            Path destinationPath = Paths.get(destination, new String[0]);
            Set<? extends IExportTemplate> templates = this.getTemplates(type);
            DelayedFiles files = new DelayedFiles();
            for (IExportTemplate iExportTemplate : templates) {
                CharSequence content = iExportTemplate.generate();
                this.getErrors().addAll(this.reformat(type, iExportTemplate.getErrors()));
                this.getWarnings().addAll(this.reformat(type, iExportTemplate.getWarnings()));
                this.getInfos().addAll(this.reformat(type, iExportTemplate.getInfos()));
                if (iExportTemplate.getErrors().isEmpty()) {
                    Path templatePath = destinationPath.resolve(iExportTemplate.getPath());
                    files.write(templatePath, content);
                    continue;
                }
                files.clear();
                break;
            }
            ICompareEditorOpener iCompareEditorOpener = CompareEditorOpenerUtil.getOpener();
            String[] buttonLabels = new String[]{JFaceResources.getString((String)"yes"), "Merge", JFaceResources.getString((String)"cancel")};
            int BUTTON_OVERWRITE = Arrays.asList(buttonLabels).indexOf(JFaceResources.getString((String)"yes"));
            int BUTTON_MERGE = Arrays.asList(buttonLabels).indexOf("Merge");
            int res = BUTTON_OVERWRITE;
            boolean filesExisted = files.exist();
            if (!forceOverwrite && filesExisted) {
                String msg = "Overwrite " + type.getName() + ".cpp" + " and " + type.getName() + ".h. " + (iCompareEditorOpener != null ? "\nMerge will create a backup of the original File and open an editor to merge the files manually!" : "");
                MessageDialog msgDiag = new MessageDialog(Display.getDefault().getActiveShell(), "File Exists", null, msg, 6, buttonLabels, 0);
                res = msgDiag.open();
            }
            boolean bl = overwrite = forceOverwrite || BUTTON_OVERWRITE == res;
            if (overwrite || BUTTON_MERGE == res) {
                Iterable<DelayedFiles.StoredFiles> writtenFiles = files.write(overwrite);
                boolean diffs = false;
                if (!overwrite && iCompareEditorOpener != null) {
                    for (DelayedFiles.StoredFiles sf : writtenFiles) {
                        if (sf.getNewFile() == null || sf.getOldFile() == null) continue;
                        iCompareEditorOpener.setName(sf.getNewFile().getName());
                        iCompareEditorOpener.setTitle(sf.getNewFile().getName());
                        iCompareEditorOpener.setNewFile(sf.getNewFile());
                        iCompareEditorOpener.setOriginalFile(sf.getOldFile());
                        if (!iCompareEditorOpener.hasDifferences()) continue;
                        iCompareEditorOpener.openCompareEditor();
                        diffs = true;
                    }
                }
                if (!diffs && filesExisted && !forceOverwrite) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No Differences", (String)"There where no differences between the orignal file and the newly generated one!");
                }
            }
        }
        catch (Exception t) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.fordiac.ide.export", 1, Messages.TemplateExportFilter_ErrorDuringTemplateGeneration, (Throwable)t));
            this.getErrors().add(t.getMessage() != null ? t.getMessage() : Messages.TemplateExportFilter_ErrorDuringTemplateGeneration);
        }
    }

    protected abstract Set<? extends IExportTemplate> getTemplates(LibraryElement var1);
}

