/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.DownloadRunnable;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.data.DeviceDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public enum DeploymentCoordinator {
    INSTANCE;

    private static final String OUTPUT_VIEW_ID = "org.eclipse.fordiac.ide.deployment.ui.views.Output";
    private final Map<Device, List<VarDeclaration>> deployedDeviceProperties = new HashMap<Device, List<VarDeclaration>>();

    public void addDeviceProperty(Device dev, VarDeclaration property) {
        if (this.deployedDeviceProperties.containsKey(dev)) {
            List<VarDeclaration> temp = this.deployedDeviceProperties.get(dev);
            if (!temp.contains(property)) {
                temp.add(property);
            }
        } else {
            ArrayList<VarDeclaration> temp = new ArrayList<VarDeclaration>();
            temp.add(property);
            this.deployedDeviceProperties.put(dev, temp);
        }
    }

    public void setDeviceProperties(Device dev, List<VarDeclaration> properties) {
        this.deployedDeviceProperties.put(dev, properties);
    }

    public void removeDeviceProperty(Device dev, VarDeclaration property) {
        List<VarDeclaration> temp;
        if (this.deployedDeviceProperties.containsKey(dev) && (temp = this.deployedDeviceProperties.get(dev)).contains(property)) {
            temp.remove(property);
        }
    }

    public List<VarDeclaration> getSelectedDeviceProperties(Device dev) {
        List<Object> retVal = this.deployedDeviceProperties.get(dev);
        if (retVal == null) {
            retVal = Collections.emptyList();
        }
        return retVal;
    }

    public static void printUnsupportedDeviceProfileMessageBox(Device device, Resource res) {
        Display.getDefault().asyncExec(() -> {
            String resName;
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            String string = resName = res != null ? res.getName() : "";
            if (device.getProfile() != null && !device.getProfile().equals("")) {
                messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_DefinedProfileNotSupported, device.getProfile(), device.getName(), resName));
            } else {
                messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_ProfileNotSet, device.getName(), resName));
            }
            messageBox.open();
        });
    }

    private int countWorkCreatingFBs(FBNetwork fbNetwork) {
        int work = 0;
        for (FBNetworkElement element : fbNetwork.getNetworkElements()) {
            if (element instanceof SubApp) {
                work += this.countWorkCreatingFBs(((SubApp)element).getSubAppNetwork());
                continue;
            }
            if (!(element instanceof FB)) continue;
            ++work;
            FB fb = (FB)element;
            InterfaceList interfaceList = fb.getInterface();
            if (interfaceList == null) continue;
            for (VarDeclaration varDecl : interfaceList.getInputVars()) {
                Value value;
                if (!varDecl.getInputConnections().isEmpty() || (value = varDecl.getValue()) == null || value.getValue() == null) continue;
                ++work;
            }
        }
        return work;
    }

    public void performDeployment(Object[] selection, IDeviceManagementCommunicationHandler overrideDevMgmCommHandler, String profile) {
        IDeploymentListener outputView = (IDeploymentListener)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(OUTPUT_VIEW_ID);
        DownloadRunnable download = new DownloadRunnable(this.createDeploymentdata(selection), overrideDevMgmCommHandler, outputView, profile);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)download);
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)Messages.DeploymentCoordinator_DepoymentError, (String)ex.getMessage());
        }
        catch (InterruptedException ex) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DeploymentCoordinator_LABEL_DownloadAborted, (String)ex.getMessage());
        }
    }

    public void performDeployment(Object[] selection) {
        this.performDeployment(selection, null, null);
    }

    public void enableOutput(IDeviceManagementInteractor interactor) {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(OUTPUT_VIEW_ID);
        if (view != null) {
            interactor.addDeploymentListener((IDeploymentListener)view);
        }
    }

    public void disableOutput(IDeviceManagementInteractor interactor) {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(OUTPUT_VIEW_ID);
        if (view != null) {
            interactor.removeDeploymentListener((IDeploymentListener)view);
        }
    }

    private List<DeviceDeploymentData> createDeploymentdata(Object[] selection) {
        ArrayList<DeviceDeploymentData> data = new ArrayList<DeviceDeploymentData>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceDeploymentData devData;
            Object object = objectArray[n2];
            if (object instanceof Resource) {
                Resource res = (Resource)object;
                devData = DeploymentCoordinator.getDevData(data, res.getDevice());
                devData.addResourceData(new ResourceDeploymentData(res));
            } else if (object instanceof Device) {
                Device dev = (Device)object;
                devData = DeploymentCoordinator.getDevData(data, dev);
                devData.setSeltectedDevParams(this.getSelectedDeviceProperties((Device)object));
            }
            ++n2;
        }
        return data;
    }

    private static DeviceDeploymentData getDevData(List<DeviceDeploymentData> data, Device device) {
        DeviceDeploymentData retVal = null;
        for (DeviceDeploymentData devData : data) {
            if (device != devData.getDevice()) continue;
            retVal = devData;
            break;
        }
        if (retVal == null) {
            retVal = new DeviceDeploymentData(device);
            data.add(retVal);
        }
        return retVal;
    }
}

