/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.rename;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.refactoring.IRenameNameValidator;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.rename.ISimpleNameProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;

public class RenameElementProcessor2
extends AbstractRenameProcessor {
    protected static final Logger LOG = Logger.getLogger(RenameElementProcessor2.class);
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IRenameNameValidator nameValidator;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ISimpleNameProvider simpleNameProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private Provider<LtkIssueAcceptor> statusProvider;
    @Inject
    private IChangeSerializer changeSerializer;
    @Inject
    private IRenameStrategy2 renameStrategy;
    @Inject
    private ChangeConverter.Factory changeConverterFactory;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PUBLIC_SETTER})
    private String newName;
    private IRenameElementContext renameElementContext;
    private IProject project;
    private ResourceSet resourceSet;
    private EObject target;
    private String originalName;
    private LtkIssueAcceptor status;
    private Change change;

    @Override
    public boolean initialize(IRenameElementContext renameElementContext) {
        this.renameElementContext = renameElementContext;
        this.status = (LtkIssueAcceptor)this.statusProvider.get();
        this.project = this.projectUtil.getProject(renameElementContext.getTargetElementURI().trimFragment());
        if (this.project == null) {
            URI _targetElementURI = renameElementContext.getTargetElementURI();
            String _string = null;
            if (_targetElementURI != null) {
                _string = _targetElementURI.toString();
            }
            String _plus = "Cannot determine project from targetURI " + _string;
            this.status.add(RefactoringIssueAcceptor.Severity.ERROR, _plus, renameElementContext.getTargetElementURI());
        }
        this.resourceSet = this.resourceSetProvider.get(this.project);
        EObject target = this.resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (target == null) {
            this.status.add(RefactoringIssueAcceptor.Severity.ERROR, "Rename target does not exist", renameElementContext.getTargetElementURI());
        } else {
            this.originalName = this.simpleNameProvider.getSimpleName(target);
        }
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        URI _targetElementURI = this.renameElementContext.getTargetElementURI();
        RenameChange change = new RenameChange(this.newName, _targetElementURI);
        RenameContext renameContext = new RenameContext(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RenameChange[]{change})), this.resourceSet, this.changeSerializer, (RefactoringIssueAcceptor)this.status);
        this.renameStrategy.applyRename(renameContext);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Rename ");
        _builder.append(this.originalName);
        _builder.append(" to ");
        _builder.append(this.newName);
        ChangeConverter changeConverter = this.changeConverterFactory.create(_builder.toString(), null, this.status);
        this.changeSerializer.applyModifications((IAcceptor)changeConverter);
        this.change = changeConverter.getChange();
        return this.status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public Object[] getElements() {
        URI _targetElementURI = this.renameElementContext.getTargetElementURI();
        return new Object[]{_targetElementURI};
    }

    public String getIdentifier() {
        return String.valueOf(this.languageName) + ".renameProcessor2";
    }

    public String getProcessorName() {
        return "Rename element";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments _renameArguments = new RenameArguments(this.newName, true);
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.renameElementContext, (RenameArguments)_renameArguments, (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"}, (SharableParticipants)sharedParticipants);
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public RefactoringStatus validateNewName(String newName) {
        LtkIssueAcceptor nameStatus = (LtkIssueAcceptor)this.statusProvider.get();
        this.nameValidator.validate(this.target, newName, (RefactoringIssueAcceptor)nameStatus);
        return nameStatus.getRefactoringStatus();
    }

    @Override
    @Pure
    public String getNewName() {
        return this.newName;
    }

    @Override
    public void setNewName(String newName) {
        this.newName = newName;
    }
}

