/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.views;

import org.eclipse.fordiac.ide.deployment.monitoringbase.IMonitoringListener;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.provider.WatchesContentProvider;
import org.eclipse.fordiac.ide.monitoring.provider.WatchesLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class WatchesView
extends ViewPart {
    private FilteredTree filteredTree;
    private IMonitoringListener listener = new IMonitoringListener(){

        public void notifyTriggerEvent(PortElement port) {
        }

        public void notifyRemovePort(PortElement port) {
            WatchesView.this.filteredTree.getViewer().refresh();
        }

        public void notifyAddPort(PortElement port) {
            if (!WatchesView.this.filteredTree.isDisposed()) {
                WatchesView.this.filteredTree.getViewer().refresh();
            }
        }
    };

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        PatternFilter patternFilter = new PatternFilter();
        this.filteredTree = new FilteredTree(root, 768, patternFilter, true, true);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        this.filteredTree.setLayoutData((Object)treeGridData);
        TreeViewerColumn column1 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column1.getColumn().setText("Watched Element");
        column1.getColumn().setWidth(340);
        TreeViewerColumn column2 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column2.getColumn().setText("Value");
        column2.getColumn().setWidth(100);
        column2.setEditingSupport(new EditingSupport(column2.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof MonitoringElement && ((MonitoringElement)element).getPort().getInterfaceElement() instanceof VarDeclaration) {
                    MonitoringManager.getInstance().writeValue((MonitoringElement)element, (String)value);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof MonitoringElement) {
                    return ((MonitoringElement)element).getCurrentValue();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)WatchesView.this.filteredTree.getViewer().getTree());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.filteredTree.getViewer().getTree().setHeaderVisible(true);
        this.filteredTree.getViewer().getTree().setLinesVisible(true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new WatchesContentProvider());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new WatchesLabelProvider());
        this.filteredTree.getViewer().setInput(new Object());
        this.addWatchesAdapters();
    }

    private void addWatchesAdapters() {
        MonitoringManager.getInstance().addWatchesAdapter(this.listener);
    }

    public void dispose() {
        MonitoringManager.getInstance().removeWatchesAdapter(this.listener);
        super.dispose();
    }

    public void setFocus() {
    }
}

