/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConnectionSection
extends AbstractSection {
    private Text commentText;
    private Text sourceText;
    private Text targetText;

    protected Connection getType() {
        return (Connection)this.type;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Source);
        this.sourceText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Target);
        this.targetText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Comment);
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            if (this.getType().getSource() != null) {
                this.sourceText.setText(String.valueOf(ConnectionSection.getFBNameFromIInterfaceElement(this.getType().getSource())) + "." + this.getType().getSource().getName());
            }
            if (this.getType().getDestination() != null) {
                this.targetText.setText(String.valueOf(ConnectionSection.getFBNameFromIInterfaceElement(this.getType().getDestination())) + "." + this.getType().getDestination().getName());
            }
        }
        this.commandStack = commandStackBuffer;
    }

    protected Connection getInputType(Object input) {
        Object inputHelper;
        Object object = inputHelper = input instanceof EditPart ? ((EditPart)input).getModel() : input;
        if (inputHelper instanceof Connection) {
            return (Connection)inputHelper;
        }
        return null;
    }

    private static String getFBNameFromIInterfaceElement(IInterfaceElement element) {
        return element.eContainer().eContainer() instanceof FBNetworkElement ? ((FBNetworkElement)element.eContainer().eContainer()).getName() : "";
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
    }
}

