/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.provider.VersionContentProvider;
import org.eclipse.fordiac.ide.gef.provider.VersionLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeApplicationDomainCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAuthorCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeClassificationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDateCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDescriptionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFunctionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeIdentifcationTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOrganizationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeRemarksCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStandardCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVersionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewVersionInfoCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteVersionInfoCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class TypeInfoSection
extends AbstractSection {
    private Text fbTypeNameText;
    private Text commentText;
    private Text standardText;
    private Text classificationText;
    private Text domainText;
    private Text functionText;
    private Text typeText;
    private Text descriptionText;
    private TableViewer versionViewer;
    private static final String VERSION_PROPERTY = "version";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String DATE_PROPERTY = "date";
    private static final String REMARKS_PROPERTY = "remarks";

    protected LibraryElement getType() {
        return (LibraryElement)this.type;
    }

    @Override
    protected void setInputInit() {
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(this.getLeftComposite());
        this.createIdentificationGroup(this.getLeftComposite());
        this.createVersionInfoGroup(this.getRightComposite());
    }

    private void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.TypeName) + ":");
        this.fbTypeNameText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Comment) + ":");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)TypeInfoSection.this.getType(), TypeInfoSection.this.commentText.getText()));
            }
        });
    }

    private void createIdentificationGroup(Composite parent) {
        Group identificationGroup = this.getWidgetFactory().createGroup(parent, FordiacMessages.Identification);
        identificationGroup.setLayout((Layout)new GridLayout(2, false));
        identificationGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Standard) + ":");
        this.standardText = this.createGroupText((Composite)identificationGroup, true);
        this.standardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeStandardCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.standardText.getText()));
            }
        });
        this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Classification) + ":");
        this.classificationText = this.createGroupText((Composite)identificationGroup, true);
        this.classificationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeClassificationCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.classificationText.getText()));
            }
        });
        this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.ApplicationDomain) + ":");
        this.domainText = this.createGroupText((Composite)identificationGroup, true);
        this.domainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeApplicationDomainCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.domainText.getText()));
            }
        });
        this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Function) + ":");
        this.functionText = this.createGroupText((Composite)identificationGroup, true);
        this.functionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeFunctionCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.functionText.getText()));
            }
        });
        this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Type) + ":");
        this.typeText = this.createGroupText((Composite)identificationGroup, true);
        this.typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeIdentifcationTypeCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.typeText.getText()));
            }
        });
        CLabel label = this.getWidgetFactory().createCLabel((Composite)identificationGroup, String.valueOf(FordiacMessages.Description) + ":");
        label.setLayoutData((Object)new GridData(0, 128, false, false));
        this.descriptionText = this.getWidgetFactory().createText((Composite)identificationGroup, "", 2882);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeInfoSection.this.executeCommand((Command)new ChangeDescriptionCommand(TypeInfoSection.this.getType(), TypeInfoSection.this.descriptionText.getText()));
            }
        });
    }

    private void createVersionInfoGroup(Composite parent) {
        Group versionInfoGroup = this.getWidgetFactory().createGroup(parent, FordiacMessages.VersionInfo);
        versionInfoGroup.setLayout((Layout)new GridLayout(2, false));
        versionInfoGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        AddDeleteWidget buttons = new AddDeleteWidget();
        buttons.createControls((Composite)versionInfoGroup, this.getWidgetFactory());
        this.versionViewer = TableWidgetFactory.createPropertyTableViewer((Composite)versionInfoGroup);
        TypeInfoSection.configureTableLayout(this.versionViewer.getTable());
        Table table = this.versionViewer.getTable();
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.versionViewer.setColumnProperties(new String[]{VERSION_PROPERTY, ORGANIZATION_PROPERTY, AUTHOR_PROPERTY, DATE_PROPERTY, REMARKS_PROPERTY});
        buttons.bindToTableViewer(this.versionViewer, (CommandExecutor)this, ref -> new AddNewVersionInfoCommand(this.getType()), ref -> new DeleteVersionInfoCommand(this.getType(), (VersionInfo)ref));
        this.versionViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                switch (property) {
                    case "version": {
                        return ((VersionInfo)element).getVersion();
                    }
                    case "organization": {
                        return ((VersionInfo)element).getOrganization();
                    }
                    case "author": {
                        return ((VersionInfo)element).getAuthor();
                    }
                    case "date": {
                        return ((VersionInfo)element).getDate();
                    }
                }
                return ((VersionInfo)element).getRemarks();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                VersionInfo data = (VersionInfo)tableItem.getData();
                ChangeRemarksCommand cmd = null;
                switch (property) {
                    case "version": {
                        cmd = new ChangeVersionCommand(data, value.toString());
                        break;
                    }
                    case "organization": {
                        cmd = new ChangeOrganizationCommand(data, value.toString());
                        break;
                    }
                    case "author": {
                        cmd = new ChangeAuthorCommand(data, value.toString());
                        break;
                    }
                    case "date": {
                        cmd = new ChangeDateCommand(data, value.toString());
                        break;
                    }
                    default: {
                        cmd = new ChangeRemarksCommand(data, value.toString());
                    }
                }
                TypeInfoSection.this.executeCommand((Command)cmd);
                TypeInfoSection.this.versionViewer.refresh((Object)data);
            }
        });
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Version);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Organization);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Author);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.Date);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.Remarks);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 90));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 100));
        table.setLayout((Layout)layout);
    }

    @Override
    public void setInputCode() {
        this.commentText.setEnabled(false);
        this.standardText.setEnabled(false);
        this.classificationText.setEnabled(false);
        this.domainText.setEnabled(false);
        this.functionText.setEnabled(false);
        this.typeText.setEnabled(false);
        this.descriptionText.setEnabled(false);
        this.versionViewer.setCellModifier(null);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.fbTypeNameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            if (this.getType().getIdentification() != null) {
                this.standardText.setText(this.getType().getIdentification().getStandard() != null ? this.getType().getIdentification().getStandard() : "");
                this.classificationText.setText(this.getType().getIdentification().getClassification() != null ? this.getType().getIdentification().getClassification() : "");
                this.domainText.setText(this.getType().getIdentification().getApplicationDomain() != null ? this.getType().getIdentification().getApplicationDomain() : "");
                this.functionText.setText(this.getType().getIdentification().getFunction() != null ? this.getType().getIdentification().getFunction() : "");
                this.typeText.setText(this.getType().getIdentification().getType() != null ? this.getType().getIdentification().getType() : "");
                this.descriptionText.setText(this.getType().getIdentification().getDescription() != null ? this.getType().getIdentification().getDescription() : "");
                this.versionViewer.setInput((Object)this.getType());
            } else {
                this.getType().setIdentification(LibraryElementFactory.eINSTANCE.createIdentification());
            }
        }
        this.commandStack = commandStackBuffer;
    }
}

