/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.gerrit.GerritDialogSettings;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PushToGerritPage
extends WizardPage {
    private static final String LAST_BRANCH_POSTFIX = ".lastBranch";
    private static final String LAST_TOPICS_POSTFIX = ".lastTopics";
    private static final String GERRIT_TOPIC_KEY = "gerritTopic";
    private static final String GERRIT_TOPIC_USE_KEY = "gerritTopicUse";
    private static final Pattern WHITESPACE = Pattern.compile("\\p{javaWhitespace}");
    private final Repository repository;
    private final IDialogSettings settings;
    private final String lastUriKey;
    private final String lastBranchKey;
    private Combo uriCombo;
    private Combo prefixCombo;
    private Label branchTextlabel;
    private Text branchText;
    private Button useTopic;
    private Label topicLabel;
    private Text topicText;
    private Set<String> knownRemoteRefs = new TreeSet<String>(CommonUtils.STRING_ASCENDING_COMPARATOR);
    private Map<String, String> topicProposals = new LinkedHashMap<String, String>(30, 0.75f, true){
        private static final int TOPIC_PROPOSALS_MAXIMUM = 20;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 20;
        }
    };

    PushToGerritPage(Repository repository) {
        super(PushToGerritPage.class.getName());
        this.repository = repository;
        this.setTitle(NLS.bind((String)UIText.PushToGerritPage_Title, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(repository)));
        this.setMessage(UIText.PushToGerritPage_Message);
        this.settings = this.getDialogSettings();
        this.lastUriKey = repository + ".lastUri";
        this.lastBranchKey = repository + LAST_BRANCH_POSTFIX;
    }

    protected IDialogSettings getDialogSettings() {
        return GerritDialogSettings.getSection(GerritDialogSettings.PUSH_TO_GERRIT_SECTION);
    }

    public void createControl(Composite parent) {
        this.loadKnownRemoteRefs();
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(UIText.PushToGerritPage_UriLabel);
        this.uriCombo = new Combo(main, 4);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.uriCombo);
        this.uriCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushToGerritPage.this.checkPage();
            }
        });
        this.branchTextlabel = new Label(main, 0);
        this.prefixCombo = new Combo(main, 12);
        this.prefixCombo.add("refs/for/");
        this.prefixCombo.add("refs/drafts/");
        this.prefixCombo.select(0);
        this.branchTextlabel.setText(UIText.PushToGerritPage_BranchLabel);
        this.branchText = new Text(main, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushToGerritPage.this.checkPage();
            }
        });
        this.branchTextlabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                PushToGerritPage.this.branchText.setFocus();
                PushToGerritPage.this.branchText.selectAll();
            }
        });
        this.addRefContentProposalToText(this.branchText);
        this.useTopic = new Button(main, 16416);
        this.useTopic.setText(UIText.PushToGerritPage_TopicUseLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.useTopic);
        this.topicLabel = new Label(main, 0);
        this.topicLabel.setText(UIText.PushToGerritPage_TopicLabel);
        this.topicText = new Text(main, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.topicText);
        this.topicText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushToGerritPage.this.checkPage();
            }
        });
        this.topicLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                PushToGerritPage.this.topicText.setFocus();
                PushToGerritPage.this.topicText.selectAll();
            }
        });
        this.useTopic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PushToGerritPage.this.topicText.setEnabled(PushToGerritPage.this.useTopic.getSelection());
                PushToGerritPage.this.checkPage();
            }
        });
        TreeSet<String> uris = new TreeSet<String>();
        try {
            for (RemoteConfig rc : RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig())) {
                if (!GerritUtil.isGerritPush((RemoteConfig)rc)) continue;
                if (rc.getURIs().size() > 0) {
                    uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                }
                for (URIish u : rc.getPushURIs()) {
                    uris.add(u.toPrivateString());
                }
            }
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
        }
        for (String aUri : uris) {
            this.uriCombo.add(aUri);
        }
        this.selectLastUsedUri();
        this.setLastUsedBranch();
        this.initializeTopic(this.branchText.getText());
        this.addTopicProposal(this.topicText);
        this.branchText.setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    private void loadKnownRemoteRefs() {
        try {
            List refs = this.repository.getRefDatabase().getRefsByPrefix("refs/remotes/");
            for (Ref ref : refs) {
                String refName = ref.getName().substring("refs/remotes/".length());
                int slashIndex = refName.indexOf(47);
                if (slashIndex <= 0 || slashIndex >= refName.length() - 1) continue;
                this.knownRemoteRefs.add(refName.substring(slashIndex + 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void storeLastUsedUri(String uri) {
        this.settings.put(this.lastUriKey, uri.trim());
    }

    private void storeLastUsedBranch(String branch) {
        this.settings.put(this.lastBranchKey, branch.trim());
    }

    private void storeLastUsedTopic(boolean enabled, String topic, String branch) {
        boolean isValid;
        boolean bl = isValid = this.validateTopic(topic) == null;
        if (topic.equals(branch)) {
            topic = null;
        } else if (topic.isEmpty()) {
            enabled = false;
        } else if (isValid) {
            this.topicProposals.put(topic, null);
            this.settings.put(this.repository + LAST_TOPICS_POSTFIX, this.topicProposals.keySet().toArray(new String[0]));
        }
        if (branch != null && !ObjectId.isId((String)branch)) {
            StoredConfig config = this.repository.getConfig();
            if (enabled) {
                config.setBoolean("branch", branch, GERRIT_TOPIC_USE_KEY, enabled);
            } else {
                config.unset("branch", branch, GERRIT_TOPIC_USE_KEY);
            }
            if (topic == null || topic.isEmpty()) {
                config.unset("branch", branch, GERRIT_TOPIC_KEY);
            } else if (isValid) {
                config.setString("branch", branch, GERRIT_TOPIC_KEY, topic);
            }
            try {
                config.save();
            }
            catch (IOException e) {
                Activator.logError(NLS.bind((String)UIText.PushToGerritPage_TopicSaveFailure, (Object)this.repository), e);
            }
        }
    }

    private void selectLastUsedUri() {
        int i;
        String lastUri = this.settings.get(this.lastUriKey);
        if (lastUri != null && (i = this.uriCombo.indexOf(lastUri)) != -1) {
            this.uriCombo.select(i);
            return;
        }
        this.uriCombo.select(0);
    }

    private void setLastUsedBranch() {
        String lastBranch = this.settings.get(this.lastBranchKey);
        try {
            BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), this.repository.getBranch());
            String trackedBranch = branchConfig.getMerge();
            if (trackedBranch != null) {
                lastBranch = trackedBranch.replace("refs/heads/", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (lastBranch != null) {
            this.branchText.setText(lastBranch);
        }
    }

    private void initializeTopic(String remoteBranch) {
        boolean enabled = false;
        String storedTopic = null;
        String branch = null;
        try {
            branch = this.repository.getBranch();
            if (ObjectId.isId((String)branch)) {
                branch = null;
            }
        }
        catch (IOException e) {
            Activator.logError(e.getLocalizedMessage(), e);
        }
        if (branch != null) {
            StoredConfig config = this.repository.getConfig();
            enabled = config.getBoolean("branch", branch, GERRIT_TOPIC_USE_KEY, false);
            storedTopic = config.getString("branch", branch, GERRIT_TOPIC_KEY);
        }
        if (storedTopic == null || storedTopic.isEmpty()) {
            if (branch != null && !branch.isEmpty() && !branch.equals(remoteBranch)) {
                this.topicText.setText(branch);
            }
        } else {
            this.topicText.setText(storedTopic);
        }
        this.useTopic.setSelection(enabled);
        this.topicText.setEnabled(enabled);
        String[] proposals = this.settings.getArray(this.repository + LAST_TOPICS_POSTFIX);
        if (proposals != null) {
            int i = proposals.length - 1;
            while (i >= 0) {
                if (!proposals[i].isEmpty()) {
                    this.topicProposals.put(proposals[i], null);
                }
                --i;
            }
        }
    }

    private void checkPage() {
        block6: {
            block5: {
                this.setErrorMessage(null);
                try {
                    if (this.uriCombo.getText().length() != 0) break block5;
                    this.setErrorMessage(UIText.PushToGerritPage_MissingUriMessage);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (!this.branchText.getText().trim().isEmpty()) break block6;
            this.setErrorMessage(UIText.PushToGerritPage_MissingBranchMessage);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.topicText.isEnabled()) {
            this.setErrorMessage(this.validateTopic(this.topicText.getText().trim()));
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private String validateTopic(String topic) {
        if (WHITESPACE.matcher(topic).find()) {
            return UIText.PushToGerritPage_TopicHasWhitespace;
        }
        if (topic.indexOf(44) >= 0) {
            if (topic.indexOf(37) >= 0) {
                return UIText.PushToGerritPage_TopicInvalidCharacters;
            }
            String withTopic = this.branchText.getText().trim();
            int i = withTopic.indexOf(37);
            if (i >= 0) {
                withTopic = withTopic.substring(0, i);
            }
            if (this.knownRemoteRefs.contains(withTopic = String.valueOf(withTopic) + '/' + topic)) {
                return NLS.bind((String)UIText.PushToGerritPage_TopicCollidesWithBranch, (Object)withTopic);
            }
        }
        return null;
    }

    private String setTopicInRef(String ref, String topic) {
        String options;
        String baseRef;
        int i = ref.indexOf(37);
        if (i >= 0) {
            baseRef = ref.substring(0, i);
            options = ref.substring(i + 1);
            options = options.replaceAll("topic=[^,]*", "");
        } else {
            baseRef = ref;
            options = "";
        }
        if (topic.indexOf(44) >= 0) {
            baseRef = String.valueOf(baseRef) + '/' + topic;
        } else {
            if (!options.isEmpty()) {
                options = String.valueOf(options) + ',';
            }
            options = String.valueOf(options) + "topic=" + topic;
        }
        if (!options.isEmpty()) {
            return String.valueOf(baseRef) + '%' + options;
        }
        return baseRef;
    }

    void doPush() {
        try {
            URIish uri = new URIish(this.uriCombo.getText());
            Ref currentHead = this.repository.exactRef("HEAD");
            String ref = String.valueOf(this.prefixCombo.getItem(this.prefixCombo.getSelectionIndex())) + this.branchText.getText().trim();
            if (this.topicText.isEnabled()) {
                ref = this.setTopicInRef(ref, this.topicText.getText().trim());
            }
            RemoteRefUpdate update = new RemoteRefUpdate(this.repository, currentHead, ref, false, null, null);
            PushOperationSpecification spec = new PushOperationSpecification();
            spec.addURIRefUpdates(uri, Arrays.asList(update));
            PushOperationUI op = new PushOperationUI(this.repository, spec, false);
            this.storeLastUsedUri(this.uriCombo.getText());
            this.storeLastUsedBranch(this.branchText.getText());
            this.storeLastUsedTopic(this.topicText.isEnabled(), this.topicText.getText().trim(), this.repository.getBranch());
            op.setPushMode(PushMode.GERRIT);
            op.start();
        }
        catch (IOException | URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void addTopicProposal(Text textField) {
        if (this.topicProposals.isEmpty()) {
            return;
        }
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke != null) {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.PushToGerritPage_TopicContentProposalHoverText, (Object)stroke.format()));
        }
        String[] recentTopics = this.topicProposals.keySet().toArray(new String[0]);
        Arrays.sort(recentTopics, CommonUtils.STRING_ASCENDING_COMPARATOR);
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(recentTopics);
        proposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, stroke, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    private void addRefContentProposalToText(Text textField) {
        UIUtils.addContentProposalToText(textField, () -> this.knownRemoteRefs, (pattern, refName) -> {
            if (pattern != null && !pattern.matcher((CharSequence)refName).matches()) {
                return null;
            }
            return new ContentProposal(refName);
        }, null, UIText.PushToGerritPage_ContentProposalStartTypingText, UIText.PushToGerritPage_ContentProposalHoverText);
    }
}

