/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;

public abstract class AbstractHoverTest
extends AbstractEditorTest {
    @Inject
    protected IEObjectHover eObjectHover;
    @Inject
    @Extension
    protected SyncUtil _syncUtil;
    @Inject
    @Extension
    protected FileExtensionProvider _fileExtensionProvider;

    public void hasHoverOver(CharSequence it, String hoverText, String hoverContent) {
        int _indexOf = it.toString().indexOf(hoverText);
        int _length = hoverText.length();
        Region _region = new Region(_indexOf, _length);
        this.hasHoverOver(it, (IRegion)_region, hoverContent);
    }

    public void hasHoverOver(CharSequence it, IRegion hoverRegion, String hoverContent) {
        this.hoverPopupHasContent(this.hoveringOver(this.dslFile(it), hoverRegion), hoverContent);
    }

    protected IFile dslFile(CharSequence content) {
        try {
            boolean _not;
            IFile _xblockexpression = null;
            IFile file = IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content.toString());
            IProject project = file.getProject();
            boolean _hasNature = project.hasNature("org.eclipse.xtext.ui.shared.xtextNature");
            boolean bl = _not = !_hasNature;
            if (_not) {
                IResourcesSetupUtil.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            _xblockexpression = file;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getProjectName() {
        return "HoverTestProject";
    }

    protected String getFileName() {
        return "hover";
    }

    protected String getFileExtension() {
        return this._fileExtensionProvider.getPrimaryFileExtension();
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        try {
            XtextEditor _xblockexpression = null;
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            this._syncUtil.waitForBuild((IProgressMonitor)_nullProgressMonitor);
            _xblockexpression = this.openEditor(dslFile);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected BrowserInformationControlInput hoveringOver(IFile dslFile, IRegion hoverRegion) {
        BrowserInformationControlInput _xblockexpression = null;
        XtextEditor editor = this.openInEditor(dslFile);
        ITextHoverExtension2 textHover = (ITextHoverExtension2)this.eObjectHover;
        Object _hoverInfo2 = textHover.getHoverInfo2((ITextViewer)editor.getInternalSourceViewer(), hoverRegion);
        _xblockexpression = (BrowserInformationControlInput)_hoverInfo2;
        return _xblockexpression;
    }

    protected void hoverPopupHasContent(BrowserInformationControlInput info, String expectedHoverContent) {
        Assert.assertNotNull((String)"No hover found!", (Object)info);
        String actualHoverContent = info.getHtml();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Could not find the text '");
        _builder.append(expectedHoverContent);
        _builder.append("' in the hover popup:");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(actualHoverContent, "\t");
        _builder.newLineIfNotEmpty();
        Assert.assertTrue((String)_builder.toString(), (boolean)actualHoverContent.contains(expectedHoverContent));
    }
}

