/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.Activator;

public final class SystemPaletteManagement {
    public static void copyToolTypeLibToProject(IProject project) {
        try {
            SystemPaletteManagement.copyDirectory((IContainer)TypeLibrary.getToolLibFolder(), (IContainer)project);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private static void copyDirectory(IContainer sourceLocation, IContainer targetLocation) throws IOException, CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!targetLocation.exists()) {
            ((IFolder)targetLocation).create(true, true, (IProgressMonitor)monitor);
            targetLocation.refreshLocal(2, (IProgressMonitor)monitor);
        }
        IResource[] iResourceArray = sourceLocation.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!resource.getName().startsWith(".")) {
                if (resource instanceof IFolder) {
                    IFolder target = targetLocation.getFolder((IPath)new Path(resource.getName()));
                    SystemPaletteManagement.copyDirectory((IContainer)((IFolder)resource), (IContainer)target);
                } else if (resource instanceof IFile) {
                    IFile file = targetLocation.getFile((IPath)new Path(resource.getName()));
                    File in = ((IFile)resource).getLocation().toFile();
                    File out = file.getLocation().toFile();
                    ImportUtils.copyFile((File)in, (File)out);
                }
            }
            ++n2;
        }
        targetLocation.refreshLocal(2, (IProgressMonitor)monitor);
    }

    private SystemPaletteManagement() {
        throw new UnsupportedOperationException("SystemPaletteManagement utility class should not be instantiated!");
    }
}

