/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.ArrayDeque;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class SystemExporter
extends CommonElementExporter {
    private final AutomationSystem system;

    public SystemExporter(AutomationSystem system) {
        this.system = system;
    }

    public void saveSystem(IFile targetFile) {
        long startTime = System.currentTimeMillis();
        if (this.getWriter() != null) {
            try {
                this.createNamedElementEntry(this.system, "System");
                this.addIdentification(this.system);
                this.addVersionInfo(this.system);
                this.addApplications();
                SystemConfiguration systemConfiguration = this.system.getSystemConfiguration();
                if (systemConfiguration != null) {
                    this.addDevices(systemConfiguration.getDevices());
                    this.addMapping();
                    this.addSegment(systemConfiguration.getSegments());
                    this.addLink(systemConfiguration.getLinks());
                }
                this.addEndElement();
            }
            catch (XMLStreamException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            this.writeToFile(targetFile);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Overall Saving time for System (" + this.system.getName() + ": " + (endTime - startTime) + " ms");
    }

    private void addApplications() throws XMLStreamException {
        for (Application app : this.system.getApplication()) {
            this.addStartElement("Application");
            this.addNameAndCommentAttribute(app);
            this.addAttributes(app.getAttributes());
            new FBNetworkExporter(this).createFBNetworkElement(app.getFBNetwork());
            this.addEndElement();
        }
    }

    private void addLink(EList<Link> linkList) throws XMLStreamException {
        for (Link link : linkList) {
            this.addStartElement("Link");
            this.getWriter().writeAttribute("SegmentName", link.getSegment().getName());
            this.getWriter().writeAttribute("CommResource", link.getDevice().getName());
            this.getWriter().writeAttribute("Comment", link.getComment());
            this.addEndElement();
        }
    }

    private void addSegment(EList<Segment> segementList) throws XMLStreamException {
        for (Segment segment : segementList) {
            this.addStartElement("Segment");
            this.addNameTypeCommentAttribute(segment, segment.getType());
            this.addXYAttributes(segment.getX(), segment.getY());
            this.getWriter().writeAttribute("dx1", CoordinateConverter.INSTANCE.convertTo1499XML(segment.getWidth()));
            this.addColorAttributeElement(segment);
            this.addAttributes(segment.getAttributes());
            this.addEndElement();
        }
    }

    private void addMapping() throws XMLStreamException {
        for (Mapping mappingEntry : this.system.getMapping()) {
            String fromString = SystemExporter.getFullHierarchicalName(mappingEntry.getFrom());
            String toString = SystemExporter.getFullHierarchicalName(mappingEntry.getTo());
            if (fromString == null || toString == null) continue;
            this.addEmptyStartElement("Mapping");
            this.getWriter().writeAttribute("From", fromString);
            this.getWriter().writeAttribute("To", toString);
        }
    }

    private static String getFullHierarchicalName(FBNetworkElement fbNetworkElement) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        if (fbNetworkElement != null) {
            FBNetworkElement runner;
            names.addFirst(fbNetworkElement.getName());
            FBNetworkElement container = fbNetworkElement;
            while ((container = (runner = container).getFbNetwork().eContainer()) instanceof INamedElement) {
                names.addFirst(".");
                names.addFirst(((INamedElement)container).getName());
                if (container instanceof Resource) {
                    names.addFirst(".");
                    names.addFirst(((Resource)((Object)container)).getDevice().getName());
                    break;
                }
                if (container instanceof FBNetworkElement) continue;
            }
            StringBuilder fullName = new StringBuilder();
            for (String string : names) {
                fullName.append(string);
            }
            return fullName.toString();
        }
        return null;
    }

    private void addDevices(EList<Device> deviceList) throws XMLStreamException {
        for (Device device : deviceList) {
            this.addStartElement("Device");
            this.addNameTypeCommentAttribute(device, device.getType());
            this.addXYAttributes(device);
            this.addParamsConfig((EList<VarDeclaration>)device.getVarDeclarations());
            this.addDeviceAttributes(device);
            this.addResources(device.getResource());
            this.addEndElement();
        }
    }

    private void addDeviceAttributes(Device device) throws XMLStreamException {
        this.addDeviceProfile(device);
        this.addColorAttributeElement(device);
        this.addAttributes(device.getAttributes());
    }

    private void addAttributes(EList<Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            this.addAttributeElement(attribute.getName(), attribute.getType().getName(), attribute.getValue(), attribute.getComment());
        }
    }

    private void addDeviceProfile(Device device) throws XMLStreamException {
        String profileName = device.getProfile();
        if (profileName != null && !"".equals(profileName)) {
            this.addAttributeElement("Profile", "STRING", profileName, "device profile");
        }
    }

    private void addResources(EList<Resource> resourceList) throws XMLStreamException {
        for (Resource resource : resourceList) {
            if (resource.isDeviceTypeResource()) continue;
            this.addStartElement("Resource");
            this.addNameTypeCommentAttribute(resource, resource.getType());
            this.addXYAttributes(0, 0);
            this.addParamsConfig((EList<VarDeclaration>)resource.getVarDeclarations());
            new FBNetworkExporter(this).createFBNetworkElement(resource.getFBNetwork());
            this.addEndElement();
        }
    }
}

