/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;

class CommonElementImporter {
    private XMLStreamReader reader;

    protected CommonElementImporter() {
    }

    protected CommonElementImporter(XMLStreamReader reader) {
        this.reader = reader;
    }

    protected ImporterStreams createInputStreams(InputStream fileInputStream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.reader = factory.createXMLStreamReader(fileInputStream);
        return new ImporterStreams(fileInputStream, this.reader);
    }

    public XMLStreamReader getReader() {
        return this.reader;
    }

    protected void proceedToStartElementNamed(String elementName) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (1 != event || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        }
        throw new XMLStreamException("Could not find start element named: " + elementName);
    }

    protected void proceedToEndElementNamed(String elementName) throws XMLStreamException {
        do {
            if (2 != this.reader.getEventType() || !this.reader.getLocalName().equals(elementName)) continue;
            return;
        } while (this.reader.hasNext() && this.reader.next() != 0);
        throw new XMLStreamException("Could not find end element named: " + elementName);
    }

    protected void processChildren(String elementName, IChildHandler childHandler) throws XMLStreamException, TypeImportException {
        while (this.getReader().hasNext()) {
            int event = this.getReader().next();
            if (1 == event) {
                if (childHandler.checkChild(this.getReader().getLocalName())) continue;
                throw new XMLStreamException("Unexpected xml child (" + this.getReader().getLocalName() + ") found in " + elementName);
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals(elementName)) break;
            throw new XMLStreamException("Unexpected xml end tag found in " + elementName + ": " + this.getReader().getLocalName());
        }
    }

    protected void parseIdentification(LibraryElement elem) throws XMLStreamException {
        String description;
        String type;
        String function;
        String applicationDomain;
        String classification;
        Identification ident = LibraryElementFactory.eINSTANCE.createIdentification();
        String standard = this.getAttributeValue("Standard");
        if (standard != null) {
            ident.setStandard(standard);
        }
        if ((classification = this.getAttributeValue("Classification")) != null) {
            ident.setClassification(classification);
        }
        if ((applicationDomain = this.getAttributeValue("ApplicationDomain")) != null) {
            ident.setApplicationDomain(applicationDomain);
        }
        if ((function = this.getAttributeValue("Function")) != null) {
            ident.setFunction(function);
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            ident.setType(type);
        }
        if ((description = this.getAttributeValue("Description")) != null) {
            ident.setDescription(description);
        }
        elem.setIdentification(ident);
        this.proceedToEndElementNamed("Identification");
    }

    protected void parseVersionInfo(LibraryElement elem) throws TypeImportException, XMLStreamException {
        String remarks;
        String version;
        VersionInfo versionInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        String organization = this.getReader().getAttributeValue("", "Organization");
        if (organization != null) {
            versionInfo.setOrganization(organization);
        }
        if ((version = this.getReader().getAttributeValue("", "Version")) == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingVersionInfo);
        }
        versionInfo.setVersion(version);
        String author = this.getReader().getAttributeValue("", "Author");
        if (author == null) {
            throw new TypeImportException(Messages.CommonElementImporter_ERROR_MissingAuthorInfo);
        }
        versionInfo.setAuthor(author);
        String date = this.getReader().getAttributeValue("", "Date");
        if (date != null) {
            versionInfo.setDate(date);
        }
        versionInfo.setRemarks((remarks = this.getReader().getAttributeValue("", "Remarks")) != null ? remarks : "");
        elem.getVersionInfo().add((Object)versionInfo);
        this.proceedToEndElementNamed("VersionInfo");
    }

    public void getXandY(PositionableElement positionableElement) throws TypeImportException {
        try {
            String y;
            String x = this.getAttributeValue("x");
            if (x != null) {
                positionableElement.setX(CoordinateConverter.INSTANCE.convertFrom1499XML(x));
            }
            if ((y = this.getAttributeValue("y")) != null) {
                positionableElement.setY(CoordinateConverter.INSTANCE.convertFrom1499XML(y));
            }
        }
        catch (NumberFormatException nfe) {
            throw new TypeImportException(Messages.FBTImporter_POSITION_EXCEPTION, nfe);
        }
    }

    protected void readNameCommentAttributes(INamedElement namedElement) throws TypeImportException {
        this.readNameAttribute(namedElement);
        this.readCommentAttribute(namedElement);
    }

    private void readNameAttribute(INamedElement namedElement) throws TypeImportException {
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.Import_ERROR_NameNotDefined);
        }
        namedElement.setName(name);
    }

    private void readCommentAttribute(INamedElement namedElement) {
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            namedElement.setComment(comment);
        }
    }

    protected void parseGenericAttributeNode(ConfigurableObject confObject) {
        String name = this.getAttributeValue("Name");
        String type = this.getAttributeValue("Type");
        String value = this.getAttributeValue("Value");
        String comment = this.getAttributeValue("Comment");
        if (name != null && value != null) {
            confObject.setAttribute(name, type == null ? "STRING" : type, value, comment);
        }
    }

    protected VarDeclaration parseParameter() throws TypeImportException, XMLStreamException {
        VarDeclaration var = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        String name = this.getAttributeValue("Name");
        if (name == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterNotSet);
        }
        var.setName(name);
        String value = this.getAttributeValue("Value");
        if (value == null) {
            throw new TypeImportException(Messages.ImportUtils_ERROR_ParameterValueNotSet);
        }
        Value val = LibraryElementFactory.eINSTANCE.createValue();
        val.setValue(value);
        var.setValue(val);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            var.setComment(comment);
        }
        this.proceedToEndElementNamed("Parameter");
        return var;
    }

    protected String getAttributeValue(String attributeName) {
        return this.getReader().getAttributeValue("", attributeName);
    }

    protected void parseCompilerInfo(CompilableType ctype) throws TypeImportException, XMLStreamException {
        String classdef;
        CompilerInfo compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
        String header = this.getAttributeValue("header");
        if (header != null) {
            compilerInfo.setHeader(header);
        }
        if ((classdef = this.getAttributeValue("classdef")) != null) {
            compilerInfo.setClassdef(classdef);
        }
        this.processChildren("CompilerInfo", name -> {
            if ("Compiler".equals(name)) {
                this.parseCompiler(compilerInfo);
                return true;
            }
            return false;
        });
        ctype.setCompilerInfo(compilerInfo);
    }

    private void parseCompiler(CompilerInfo compilerInfo) throws TypeImportException, XMLStreamException {
        String vendor;
        Compiler comp;
        block19: {
            comp = LibraryElementFactory.eINSTANCE.createCompiler();
            String language = this.getAttributeValue("Language");
            if (language == null) break block19;
            switch (language.toUpperCase()) {
                case "C": {
                    comp.setLanguage(Language.C);
                    break;
                }
                case "CPP": {
                    comp.setLanguage(Language.CPP);
                    break;
                }
                case "JAVA": {
                    comp.setLanguage(Language.JAVA);
                    break;
                }
                case "OTHER": {
                    comp.setLanguage(Language.OTHER);
                    break;
                }
                default: {
                    throw new TypeImportException(Messages.CompilableElementImporter_ERROR_UnsupportedLanguage);
                }
            }
        }
        if ((vendor = this.getAttributeValue("Vendor")) == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VendorNotSet);
        }
        comp.setVendor(vendor);
        String product = this.getAttributeValue("Product");
        if (product == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_ProductNotSet);
        }
        comp.setProduct(product);
        String version = this.getAttributeValue("Version");
        if (version == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VersionNotSet);
        }
        comp.setVersion(version);
        this.proceedToEndElementNamed("Compiler");
        compilerInfo.getCompiler().add((Object)comp);
    }

    protected boolean isProfileAttribute() {
        String name = this.getAttributeValue("Name");
        return name != null && "Profile".equals(name);
    }

    protected void parseProfile(Device device) {
        String value = this.getAttributeValue("Value");
        if (value != null) {
            device.setProfile(value);
        }
    }

    protected static interface IChildHandler {
        public boolean checkChild(String var1) throws XMLStreamException, TypeImportException;
    }

    protected class ImporterStreams
    implements AutoCloseable {
        private final InputStream inputStream;
        private final XMLStreamReader reader;

        public ImporterStreams(InputStream inputStream, XMLStreamReader reader) {
            this.inputStream = inputStream;
            this.reader = reader;
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
            this.inputStream.close();
        }
    }
}

