/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

class SubAppNetworkImporter
extends FBNetworkImporter {
    public SubAppNetworkImporter(Palette palette, XMLStreamReader reader) {
        super(palette, reader);
    }

    public SubAppNetworkImporter(Palette palette, InterfaceList interfaceList, XMLStreamReader reader) {
        super(palette, LibraryElementFactory.eINSTANCE.createFBNetwork(), interfaceList, reader);
    }

    protected SubAppNetworkImporter(Palette palette, FBNetwork fbNetwork, XMLStreamReader reader) {
        super(palette, fbNetwork, reader);
    }

    @Override
    public FBNetwork parseFBNetwork(String networkNodeName) throws TypeImportException, XMLStreamException {
        this.processChildren(networkNodeName, name -> {
            switch (name) {
                case "FB": {
                    this.parseFB();
                    break;
                }
                case "SubApp": {
                    this.parseSubApp();
                    break;
                }
                case "EventConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getEventConnection(), this.getFbNetwork().getEventConnections(), "EventConnections");
                    break;
                }
                case "DataConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getDataConnection(), this.getFbNetwork().getDataConnections(), "DataConnections");
                    break;
                }
                case "AdapterConnections": {
                    this.parseConnectionList(LibraryElementPackage.eINSTANCE.getAdapterConnection(), this.getFbNetwork().getAdapterConnections(), "AdapterConnections");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return this.getFbNetwork();
    }

    private void parseSubApp() throws TypeImportException, XMLStreamException {
        SubApp subApp = LibraryElementFactory.eINSTANCE.createSubApp();
        this.readNameCommentAttributes(subApp);
        this.getXandY(subApp);
        String type = this.getAttributeValue("Type");
        if (type != null) {
            this.configureSubAppInterface(subApp, type);
        } else {
            this.parseUntypedSubapp(subApp);
        }
        this.getFbNetwork().getNetworkElements().add((Object)subApp);
        this.fbNetworkElementMap.put(subApp.getName(), subApp);
    }

    private void configureSubAppInterface(SubApp subApp, String typeName) throws TypeImportException, XMLStreamException {
        SubApplicationTypePaletteEntry subEntry = this.getPalette().getSubAppTypeEntry(typeName);
        if (subEntry != null) {
            subApp.setPaletteEntry(subEntry);
            subApp.setInterface((InterfaceList)EcoreUtil.copy((EObject)subEntry.getSubApplicationType().getInterfaceList()));
        } else {
            subApp.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
        this.configureParameters(subApp.getInterface(), "SubApp");
    }

    private void parseUntypedSubapp(SubApp subApp) throws TypeImportException, XMLStreamException {
        this.processChildren("SubApp", name -> {
            switch (name) {
                case "SubAppInterfaceList": {
                    SubAppTImporter interfaceImporter = new SubAppTImporter(this.getReader(), this.getPalette());
                    subApp.setInterface(interfaceImporter.parseInterfaceList("SubAppInterfaceList"));
                    break;
                }
                case "SubAppNetwork": {
                    subApp.setSubAppNetwork(new SubAppNetworkImporter(this.getPalette(), subApp.getInterface(), this.getReader()).parseFBNetwork("SubAppNetwork"));
                    break;
                }
                case "Parameter": {
                    VarDeclaration paramter = this.parseParameter();
                    VarDeclaration vInput = SubAppNetworkImporter.getVarNamed(subApp.getInterface(), paramter.getName(), true);
                    if (vInput == null) break;
                    vInput.setValue(paramter.getValue());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }
}

