/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.Palette.PalettePackage;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.typelibrary.IPaletteEntryCreator;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryTags;

public final class TypeLibrary
implements TypeLibraryTags {
    private Palette palette = PaletteFactory.eINSTANCE.createPalette();
    private static IPaletteEntryCreator[] paletteCreators = null;
    private static TypeLibrary instance;
    private static PalettePackage pack;

    static {
        pack = PalettePackage.eINSTANCE;
    }

    public static String getTypeNameFromFile(IFile element) {
        return TypeLibrary.getTypeNameFromFileName(element.getName());
    }

    public static String getTypeNameFromFileName(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (-1 != index) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static boolean isIEC61499TypeFile(String filename) {
        return filename.toUpperCase().endsWith(".FBT") || filename.toUpperCase().endsWith(".ADP") || filename.toUpperCase().endsWith(".DEV") || filename.toUpperCase().endsWith(".RES") || filename.toUpperCase().endsWith(".SEG");
    }

    public static PaletteEntry getPaletteEntryForFile(IFile typeFile, Palette palette) {
        EMap<String, ? extends PaletteEntry> typeEntryList = TypeLibrary.getTypeList(palette, typeFile);
        if (typeEntryList != null) {
            return (PaletteEntry)typeEntryList.get((Object)TypeLibrary.getTypeNameFromFile(typeFile));
        }
        return null;
    }

    private static EMap<String, ? extends PaletteEntry> getTypeList(Palette palette, IFile typeFile) {
        block22: {
            String extension = typeFile.getFileExtension();
            if (extension == null) break block22;
            switch (extension.toUpperCase()) {
                case "ADP": {
                    return palette.getAdapterTypes();
                }
                case "DEV": {
                    return palette.getDeviceTypes();
                }
                case "FBT": {
                    return palette.getFbTypes();
                }
                case "RES": {
                    return palette.getResourceTypes();
                }
                case "SEG": {
                    return palette.getSegmentTypes();
                }
                case "SUB": {
                    return palette.getSubAppTypes();
                }
            }
        }
        return null;
    }

    private TypeLibrary() {
    }

    public static TypeLibrary getInstance() {
        if (instance == null) {
            TypeLibrary newTypeLib = new TypeLibrary();
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject toolLibProject = myWorkspaceRoot.getProject("Tool Library");
            if (toolLibProject.exists()) {
                try {
                    toolLibProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
                }
            }
            newTypeLib.loadPalette();
            instance = newTypeLib;
        }
        return instance;
    }

    public Palette getPalette() {
        return this.palette;
    }

    private Palette loadPalette() {
        IFolder toolLibFolder = TypeLibrary.getToolLibFolder();
        this.palette = TypeLibrary.loadPalette((IContainer)toolLibFolder);
        return this.palette;
    }

    public static Palette loadPalette(IContainer container) {
        Palette newPalette = PaletteFactory.eINSTANCE.createPalette();
        TypeLibrary.loadPaletteFolderMembers(newPalette, container);
        return newPalette;
    }

    private static void loadPaletteFolderMembers(Palette palette, IContainer container) {
        try {
            IResource[] members;
            if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
                container.refreshLocal(1, null);
            }
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    TypeLibrary.loadPaletteFolderMembers(palette, (IContainer)((IFolder)iResource));
                }
                if (iResource instanceof IFile) {
                    TypeLibrary.createPaleteEntry(palette, (IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static PaletteEntry createPaleteEntry(Palette palette, IFile file) {
        PaletteEntry entry = null;
        IPaletteEntryCreator[] iPaletteEntryCreatorArray = TypeLibrary.getPaletteCreators();
        int n = iPaletteEntryCreatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPaletteEntryCreator in = iPaletteEntryCreatorArray[n2];
            if (in.canHandle(file)) {
                entry = in.createPaletteEntry();
                TypeLibrary.configurePaletteEntry(entry, file);
                palette.addPaletteEntry(entry);
            }
            ++n2;
        }
        return entry;
    }

    private static void setPaletteCreators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.model", "PaletteEntryCreator");
        int countPaletteCreater = 0;
        paletteCreators = new IPaletteEntryCreator[elems.length];
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement elem = elems[i];
            try {
                Object object = elem.createExecutableExtension("class");
                if (object instanceof IPaletteEntryCreator) {
                    TypeLibrary.paletteCreators[countPaletteCreater] = (IPaletteEntryCreator)object;
                    ++countPaletteCreater;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
            ++i;
        }
    }

    private static IPaletteEntryCreator[] getPaletteCreators() {
        if (paletteCreators == null) {
            TypeLibrary.setPaletteCreators();
        }
        return paletteCreators;
    }

    private static void configurePaletteEntry(PaletteEntry entry, IFile file) {
        entry.setType(null);
        entry.setLabel(TypeLibrary.getTypeNameFromFile(file));
        entry.setFile(file);
    }

    public static void refreshPalette(Palette palette) {
        IContainer container = TypeLibrary.getLibPath(palette);
        try {
            container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        TypeLibrary.checkDeletions(palette);
        TypeLibrary.checkAdditions(palette, container);
    }

    private static void checkDeletions(Palette palette) {
        TypeLibrary.checkDeletionsForTypeGroup(palette.getAdapterTypes());
        TypeLibrary.checkDeletionsForTypeGroup(palette.getDeviceTypes());
        TypeLibrary.checkDeletionsForTypeGroup(palette.getFbTypes());
        TypeLibrary.checkDeletionsForTypeGroup(palette.getResourceTypes());
        TypeLibrary.checkDeletionsForTypeGroup(palette.getSegmentTypes());
        TypeLibrary.checkDeletionsForTypeGroup(palette.getSubAppTypes());
    }

    private static void checkDeletionsForTypeGroup(EMap<String, ? extends PaletteEntry> types) {
        types.entrySet().removeIf(e -> !((PaletteEntry)e.getValue()).getFile().exists());
    }

    private static void checkAdditions(Palette palette, IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource instanceof IFolder) {
                    TypeLibrary.checkAdditions(palette, (IContainer)((IFolder)iResource));
                }
                if (iResource instanceof IFile && !TypeLibrary.paletteContainsType(palette, (IFile)iResource)) {
                    TypeLibrary.createPaleteEntry(palette, (IFile)iResource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static boolean paletteContainsType(Palette palette, IFile file) {
        String typeName = TypeLibrary.getTypeNameFromFile(file);
        return palette.getAdapterTypeEntry(typeName) != null || palette.getDeviceTypeEntry(typeName) != null || palette.getFBTypeEntry(typeName) != null || palette.getResourceTypeEntry(typeName) != null || palette.getSegmentTypeEntry(typeName) != null || palette.getSubAppTypeEntry(typeName) != null;
    }

    public static IContainer getLibPath(Palette palette) {
        Object libPath = null;
        AutomationSystem system = palette.getAutomationSystem();
        libPath = system == null ? TypeLibrary.getToolLibFolder() : system.getProject();
        return libPath;
    }

    public static IProject getToolLibProject() {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return myWorkspaceRoot.getProject("Tool Library");
    }

    public static IFolder getToolLibFolder() {
        IFolder toolLibFolder;
        IProject toolLibProject = TypeLibrary.getToolLibProject();
        if (!toolLibProject.exists()) {
            TypeLibrary.createToolLibProject(toolLibProject);
        }
        if (!(toolLibFolder = toolLibProject.getFolder("Tool Library")).exists()) {
            TypeLibrary.createToolLibLink(toolLibProject);
            toolLibFolder = toolLibProject.getFolder("Tool Library");
        }
        return toolLibFolder;
    }

    private static void createToolLibProject(IProject toolLibProject) {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        try {
            toolLibProject.create((IProgressMonitor)progressMonitor);
            toolLibProject.open((IProgressMonitor)progressMonitor);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        TypeLibrary.createToolLibLink(toolLibProject);
    }

    private static void createToolLibLink(IProject toolLibProject) {
        String typeLibPath;
        Path location;
        IFolder link;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.validateLinkLocation((IResource)(link = toolLibProject.getFolder("Tool Library")), (IPath)(location = (typeLibPath = System.getProperty("4diac.typelib.path")) != null && !typeLibPath.isEmpty() ? new Path(typeLibPath) : new Path(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "typelibrary"))).isOK()) {
            try {
                link.createLink((IPath)location, 0, null);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }
}

