/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public final class ECCContentAndLabelProvider {
    public static final String EMPTY_FIELD = Messages.ECCContentAndLabelProvider_EmptyField;
    public static final String ONE_CONDITION = "1";

    public static List<Event> getOutputEvents(BasicFBType type) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (type != null) {
            events.addAll((Collection<Event>)type.getInterfaceList().getEventOutputs());
            type.getInterfaceList().getSockets().forEach(socket -> {
                boolean bl = events.addAll(ECCContentAndLabelProvider.createAdapterEventList((EList<Event>)socket.getType().getInterfaceList().getEventInputs(), socket));
            });
            type.getInterfaceList().getPlugs().forEach(plug -> {
                boolean bl = events.addAll(ECCContentAndLabelProvider.createAdapterEventList((EList<Event>)plug.getType().getInterfaceList().getEventOutputs(), plug));
            });
            Collections.sort(events, NamedElementComparator.INSTANCE);
        }
        return events;
    }

    public static List<String> getOutputEventNames(BasicFBType type) {
        List<String> eventNames = ECCContentAndLabelProvider.getOutputEvents(type).stream().map(ev -> ev.getName()).collect(Collectors.toList());
        eventNames.add(EMPTY_FIELD);
        return eventNames;
    }

    public static List<Event> getInputEvents(BasicFBType type) {
        ArrayList<Event> transitionConditions = new ArrayList<Event>();
        if (type != null) {
            transitionConditions.addAll((Collection<Event>)type.getInterfaceList().getEventInputs());
            type.getInterfaceList().getSockets().forEach(socket -> {
                boolean bl = transitionConditions.addAll(ECCContentAndLabelProvider.createAdapterEventList((EList<Event>)socket.getType().getInterfaceList().getEventOutputs(), socket));
            });
            type.getInterfaceList().getPlugs().forEach(plug -> {
                boolean bl = transitionConditions.addAll(ECCContentAndLabelProvider.createAdapterEventList((EList<Event>)plug.getType().getInterfaceList().getEventInputs(), plug));
            });
            Collections.sort(transitionConditions, NamedElementComparator.INSTANCE);
        }
        return transitionConditions;
    }

    public static List<String> getInputEventNames(BasicFBType type) {
        List<String> inputEventNames = ECCContentAndLabelProvider.getInputEvents(type).stream().map(tc -> tc.getName()).collect(Collectors.toList());
        inputEventNames.add(EMPTY_FIELD);
        return inputEventNames;
    }

    public static List<String> getTransitionConditionEventNames(BasicFBType type) {
        ArrayList<String> transitionConditionEvents = new ArrayList<String>();
        transitionConditionEvents.add(ONE_CONDITION);
        transitionConditionEvents.addAll(ECCContentAndLabelProvider.getInputEventNames(type));
        return transitionConditionEvents;
    }

    public static List<Event> createAdapterEventList(EList<Event> events, AdapterDeclaration adapter) {
        ArrayList<Event> adapterEvents = new ArrayList<Event>();
        for (Event event : events) {
            AdapterEvent ae = LibraryElementFactory.eINSTANCE.createAdapterEvent();
            ae.setName(event.getName());
            ae.setComment(event.getComment());
            ae.setAdapterDeclaration(adapter);
            adapterEvents.add((Event)ae);
        }
        return adapterEvents;
    }

    public static List<Algorithm> getAlgorithms(BasicFBType type) {
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        algorithms.addAll((Collection<Algorithm>)type.getAlgorithm());
        Collections.sort(algorithms, NamedElementComparator.INSTANCE);
        return algorithms;
    }

    public static List<String> getAlgorithmNames(BasicFBType type) {
        List<String> algNames = ECCContentAndLabelProvider.getAlgorithms(type).stream().map(alg -> alg.getName()).collect(Collectors.toList());
        algNames.add(EMPTY_FIELD);
        return algNames;
    }

    public static BasicFBType getFBType(ECAction action) {
        if (action.getECState() != null && action.getECState().getECC() != null) {
            return action.getECState().getECC().getBasicFBType();
        }
        return null;
    }

    public static List<ECState> getStates(BasicFBType type) {
        return type.getECC().getECState();
    }

    public static List<String> getStateNames(BasicFBType type) {
        return ECCContentAndLabelProvider.getStates(type).stream().map(INamedElement::getName).collect(Collectors.toList());
    }

    private ECCContentAndLabelProvider() {
        throw new UnsupportedOperationException("ECActionHelpers should not be instantiated!");
    }
}

