/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.widgets;

import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeActionOrderCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeOutputCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ActionContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ActionEditingComposite {
    private static final String ACTION_ALGORITHM = "Algorithm";
    private static final String ACTION_EVENT = "Event";
    private static final int ACTION_COLUMN_ALGORITHM = 0;
    private static final int ACTION_COLUMN_EVENT = 1;
    private TableViewer actionViewer;
    private AddDeleteReorderListWidget actionMgmButtons;
    private TabbedPropertySheetWidgetFactory actionWidgetFactory;
    private Group actionGroup;
    private CommandStack commandStack;
    private CommandExecutor commandExecutor;
    private ECState type;

    public ActionEditingComposite(Composite parent, TabbedPropertySheetWidgetFactory actionWidgetFactory, CommandExecutor commandExecutor) {
        this.actionWidgetFactory = actionWidgetFactory;
        this.commandExecutor = commandExecutor;
        this.actionGroup = actionWidgetFactory.createGroup(parent, Messages.ActionEditingComposite_Actions);
        this.commandStack = null;
        this.type = null;
        this.createGroupLayout();
    }

    private void createGroupLayout() {
        this.actionGroup.setLayout((Layout)new GridLayout(2, false));
        this.actionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.actionMgmButtons = new AddDeleteReorderListWidget();
        this.actionMgmButtons.createControls((Composite)this.actionGroup, this.actionWidgetFactory);
        this.actionViewer = TableWidgetFactory.createTableViewer((Composite)this.actionGroup);
        this.configureActionTableLayout(this.actionViewer.getTable());
        this.actionViewer.setContentProvider((IContentProvider)new ActionContentProvider());
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new ActionListLabelProvider());
        this.actionMgmButtons.bindToTableViewer(this.actionViewer, this.commandExecutor, ref -> new CreateECActionCommand(LibraryElementFactory.eINSTANCE.createECAction(), this.type), ref -> new DeleteECActionCommand((ECAction)ref), ref -> new ChangeActionOrderCommand(this.type, (ECAction)ref, true), ref -> new ChangeActionOrderCommand(this.type, (ECAction)ref, false));
    }

    private void configureActionTableLayout(Table table) {
        new TableColumn(table, 16384).setText(Messages.ActionEditingComposite_ConfigureActionTableLayout_Algorithm);
        new TableColumn(table, 16384).setText(Messages.ActionEditingComposite_ConfigureActionTableLayout_Event);
        TableLayout tabLayout = new TableLayout();
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        table.setLayout((Layout)tabLayout);
        this.actionViewer.setColumnProperties(new String[]{ACTION_ALGORITHM, ACTION_EVENT});
    }

    private CellEditor[] createActionViewerCellEditors(Table table) {
        BasicFBType fbType = this.getBasicFBType();
        return new CellEditor[]{ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])ECCContentAndLabelProvider.getAlgorithmNames(fbType).toArray(new String[0]), (int)8), ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])ECCContentAndLabelProvider.getOutputEventNames(fbType).toArray(new String[0]), (int)8)};
    }

    private BasicFBType getBasicFBType() {
        return this.type.getECC().getBasicFBType();
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.actionViewer.setInput((Object)this.type);
        }
        this.commandStack = commandStackBuffer;
    }

    public void setTypeAndCommandStack(ECState type, CommandStack commandStack) {
        this.type = type;
        this.commandStack = commandStack;
        this.actionMgmButtons.setCreateButtonEnablement(!type.isStartState());
        this.actionViewer.setCellEditors(this.createActionViewerCellEditors(this.actionViewer.getTable()));
        this.actionViewer.setCellModifier((ICellModifier)new ActionViewerCellModifier());
    }

    private static class ActionListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ActionListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ECAction) {
                switch (columnIndex) {
                    case 0: {
                        return ((ECAction)element).getAlgorithm() != null ? ((ECAction)element).getAlgorithm().getName() : ECCContentAndLabelProvider.EMPTY_FIELD;
                    }
                    case 1: {
                        return ((ECAction)element).getOutput() != null ? ((ECAction)element).getOutput().getName() : ECCContentAndLabelProvider.EMPTY_FIELD;
                    }
                }
            }
            return ECCContentAndLabelProvider.EMPTY_FIELD;
        }
    }

    private class ActionViewerCellModifier
    implements ICellModifier {
        private ActionViewerCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            ECAction selectedAction = (ECAction)element;
            switch (property) {
                case "Algorithm": {
                    List<Algorithm> algorithms = ECCContentAndLabelProvider.getAlgorithms(ActionEditingComposite.this.getBasicFBType());
                    return selectedAction.getAlgorithm() != null ? algorithms.indexOf(selectedAction.getAlgorithm()) : algorithms.size();
                }
                case "Event": {
                    List<String> events = ECCContentAndLabelProvider.getOutputEventNames(ActionEditingComposite.this.getBasicFBType());
                    return selectedAction.getOutput() != null ? events.indexOf(selectedAction.getOutput().getName()) : events.size();
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            ECAction selectedAction = (ECAction)tableItem.getData();
            int selected = (Integer)value;
            Command cmd = null;
            switch (property) {
                case "Algorithm": {
                    List<Algorithm> algorithms = ECCContentAndLabelProvider.getAlgorithms(ActionEditingComposite.this.getBasicFBType());
                    Algorithm alg = selected < algorithms.size() ? algorithms.get(selected) : null;
                    cmd = new ChangeAlgorithmCommand(selectedAction, alg);
                    break;
                }
                case "Event": {
                    List<Event> events = ECCContentAndLabelProvider.getOutputEvents(ActionEditingComposite.this.getBasicFBType());
                    Event ev = selected >= 0 && selected < events.size() ? events.get(selected) : null;
                    cmd = new ChangeOutputCommand(selectedAction, ev);
                    break;
                }
            }
            if (cmd != null && ActionEditingComposite.this.commandStack != null) {
                ActionEditingComposite.this.commandStack.execute(cmd);
                ActionEditingComposite.this.refresh();
            }
        }
    }
}

