/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.export.ExportTemplate;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class ForteFBTemplate
extends ExportTemplate {
    public ForteFBTemplate(String name, Path prefix) {
        super(name, prefix);
    }

    protected abstract FBType getType();

    protected CharSequence generateHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** FORTE Library Element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** This file was generated using the 4DIAC FORTE Export Filter V1.0.x NG!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** Name: ");
        String _name = this.getType().getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Description: ");
        String _comment = this.getType().getComment();
        _builder.append(_comment, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*** Version:");
        _builder.newLine();
        EList _versionInfo = this.getType().getVersionInfo();
        for (VersionInfo info : _versionInfo) {
            _builder.append("***     ");
            String _version = info.getVersion();
            _builder.append(_version);
            _builder.append(": ");
            String _date = info.getDate();
            _builder.append(_date);
            _builder.append("/");
            String _author = info.getAuthor();
            _builder.append(_author);
            _builder.append(" - ");
            String _organization = info.getOrganization();
            _builder.append(_organization);
            _builder.append(" - ");
            String _remarks = info.getRemarks();
            _builder.append(_remarks);
            _builder.newLineIfNotEmpty();
        }
        _builder.append(" ");
        _builder.append("*************************************************************************/");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateIncludeGuardStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef _");
        String _upperCase = this.getType().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = this.getType().getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateIncludeGuardEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#endif // _");
        String _upperCase = this.getType().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateHeaderIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        EList _inputVars = this.getType().getInterfaceList().getInputVars();
        EList _outputVars = this.getType().getInterfaceList().getOutputVars();
        CharSequence _generateTypeIncludes = this.generateTypeIncludes(Iterables.concat((Iterable)_inputVars, (Iterable)_outputVars));
        _builder.append((Object)_generateTypeIncludes);
        _builder.newLineIfNotEmpty();
        EList _sockets = this.getType().getInterfaceList().getSockets();
        EList _plugs = this.getType().getInterfaceList().getPlugs();
        CharSequence _generateAdapterIncludes = this.generateAdapterIncludes(Iterables.concat((Iterable)_sockets, (Iterable)_plugs));
        _builder.append((Object)_generateAdapterIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CompilerInfo _compilerInfo = this.getType().getCompilerInfo();
        String _header = null;
        if (_compilerInfo != null) {
            _header = _compilerInfo.getHeader();
        }
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateImplIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _name = this.getType().getName();
        _builder.append(_name);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef FORTE_ENABLE_GENERATED_SOURCE_CPP");
        _builder.newLine();
        _builder.append("#include \"");
        String _name_1 = this.getType().getName();
        _builder.append(_name_1);
        _builder.append("_gen.cpp\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        CompilerInfo _compilerInfo = this.getType().getCompilerInfo();
        String _header = null;
        if (_compilerInfo != null) {
            _header = _compilerInfo.getHeader();
        }
        _builder.append(_header);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateTypeIncludes(Iterable<VarDeclaration> vars) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getTypeName();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(vars, (Functions.Function1)_function)));
        for (String include : _set) {
            _builder.append("#include \"forte_");
            String _lowerCase = include.toLowerCase();
            _builder.append(_lowerCase);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
            boolean _startsWith = include.startsWith("ANY");
            if (!_startsWith) continue;
            _builder.append("#ERROR type contains variables of type ANY. Please check the usage of these variables as we can not gurantee correct usage on export!");
            _builder.newLine();
        }
        Functions.Function1 _function_1 = it -> it.isArray();
        boolean _exists = IterableExtensions.exists(vars, (Functions.Function1)_function_1);
        if (_exists) {
            _builder.append("#include \"forte_array.h\"");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateAdapterIncludes(Iterable<AdapterDeclaration> vars) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getTypeName();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(vars, (Functions.Function1)_function)));
        for (String include : _set) {
            _builder.append("#include \"");
            _builder.append(include);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateFBDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DECLARE_FIRMWARE_FB(");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DEFINE_FIRMWARE_FB(");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append(", ");
        CharSequence _fORTEString = this.getFORTEString(this.getType().getName());
        _builder.append((Object)_fORTEString);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBInterfaceDeclaration() {
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.getType().getInterfaceList().getInputVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("static const CStringDictionary::TStringId scm_anDataInputNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scm_anDataInputTypeIds[];");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEmpty_1 = this.getType().getInterfaceList().getOutputVars().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("static const CStringDictionary::TStringId scm_anDataOutputNames[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scm_anDataOutputTypeIds[];");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEmpty_2 = this.getType().getInterfaceList().getEventInputs().isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            EList _eventInputs = this.getType().getInterfaceList().getEventInputs();
            for (Event event : _eventInputs) {
                _builder.append("static const TEventID scm_nEvent");
                String _name = event.getName();
                _builder.append(_name);
                _builder.append("ID = ");
                int _indexOf = this.getType().getInterfaceList().getEventInputs().indexOf((Object)event);
                _builder.append((Object)_indexOf);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("static const TDataIOID scm_anEIWith[];");
            _builder.newLine();
            _builder.append("static const TForteInt16 scm_anEIWithIndexes[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scm_anEventInputNames[];");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEmpty_3 = this.getType().getInterfaceList().getEventOutputs().isEmpty();
        boolean bl4 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            EList _eventOutputs = this.getType().getInterfaceList().getEventOutputs();
            for (Event event_1 : _eventOutputs) {
                _builder.append("static const TEventID scm_nEvent");
                String _name_1 = event_1.getName();
                _builder.append(_name_1);
                _builder.append("ID = ");
                int _indexOf_1 = this.getType().getInterfaceList().getEventOutputs().indexOf((Object)event_1);
                _builder.append((Object)_indexOf_1);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("static const TDataIOID scm_anEOWith[];");
            _builder.newLine();
            _builder.append("static const TForteInt16 scm_anEOWithIndexes[];");
            _builder.newLine();
            _builder.append("static const CStringDictionary::TStringId scm_anEventOutputNames[];");
            _builder.newLine();
        }
        _builder.newLine();
        if (!this.getType().getInterfaceList().getSockets().isEmpty() || !this.getType().getInterfaceList().getPlugs().isEmpty()) {
            EList _sockets = this.getType().getInterfaceList().getSockets();
            for (AdapterDeclaration adapter : _sockets) {
                _builder.append("static const int scm_n");
                String _name_2 = adapter.getName();
                _builder.append(_name_2);
                _builder.append("AdpNum = ");
                int _indexOf_2 = this.getType().getInterfaceList().getSockets().indexOf((Object)adapter);
                _builder.append((Object)_indexOf_2);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            EList _plugs = this.getType().getInterfaceList().getPlugs();
            for (AdapterDeclaration adapter_1 : _plugs) {
                _builder.append("static const int scm_n");
                String _name_3 = adapter_1.getName();
                _builder.append(_name_3);
                _builder.append("AdpNum = ");
                int _size = this.getType().getInterfaceList().getSockets().size();
                int _indexOf_3 = this.getType().getInterfaceList().getPlugs().indexOf((Object)adapter_1);
                int _plus = _size + _indexOf_3;
                _builder.append((Object)_plus);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("const SAdapterInstanceDef scm_astAdapterInstances[];");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateFBInterfaceDefinition() {
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        ArrayList inputWith = CollectionLiterals.newArrayList();
        ArrayList inputWithIndexes = CollectionLiterals.newArrayList();
        Consumer<Event> _function = event -> {
            boolean _isEmpty = event.getWith().isEmpty();
            if (_isEmpty) {
                inputWithIndexes.add(-1);
            } else {
                inputWithIndexes.add(inputWith.size());
                EList _with = event.getWith();
                for (With with : _with) {
                    inputWith.add(this.getType().getInterfaceList().getInputVars().indexOf((Object)with.getVariables()));
                }
                inputWith.add(255);
            }
        };
        this.getType().getInterfaceList().getEventInputs().forEach(_function);
        ArrayList outputWith = CollectionLiterals.newArrayList();
        ArrayList outputWithIndexes = CollectionLiterals.newArrayList();
        Consumer<Event> _function_1 = event -> {
            boolean _isEmpty = event.getWith().isEmpty();
            if (_isEmpty) {
                outputWithIndexes.add(-1);
            } else {
                outputWithIndexes.add(outputWith.size());
                EList _with = event.getWith();
                for (With with : _with) {
                    outputWith.add(this.getType().getInterfaceList().getOutputVars().indexOf((Object)with.getVariables()));
                }
                outputWith.add(255);
            }
        };
        this.getType().getInterfaceList().getEventOutputs().forEach(_function_1);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.getType().getInterfaceList().getInputVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::scm_anDataInputNames[] = {");
            CharSequence _fORTENameList = this.getFORTENameList((List<? extends INamedElement>)this.getType().getInterfaceList().getInputVars());
            _builder.append((Object)_fORTENameList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_1 = this.getFBClassName();
            _builder.append((Object)_fBClassName_1);
            _builder.append("::scm_anDataInputTypeIds[] = {");
            CharSequence _fORTETypeList = this.getFORTETypeList((List<? extends VarDeclaration>)this.getType().getInterfaceList().getInputVars());
            _builder.append((Object)_fORTETypeList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty_1 = this.getType().getInterfaceList().getOutputVars().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_2 = this.getFBClassName();
            _builder.append((Object)_fBClassName_2);
            _builder.append("::scm_anDataOutputNames[] = {");
            CharSequence _fORTENameList_1 = this.getFORTENameList((List<? extends INamedElement>)this.getType().getInterfaceList().getOutputVars());
            _builder.append((Object)_fORTENameList_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_3 = this.getFBClassName();
            _builder.append((Object)_fBClassName_3);
            _builder.append("::scm_anDataOutputTypeIds[] = {");
            CharSequence _fORTETypeList_1 = this.getFORTETypeList((List<? extends VarDeclaration>)this.getType().getInterfaceList().getOutputVars());
            _builder.append((Object)_fORTETypeList_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty_2 = this.getType().getInterfaceList().getEventInputs().isEmpty();
        boolean bl3 = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append("const TDataIOID ");
            CharSequence _fBClassName_4 = this.getFBClassName();
            _builder.append((Object)_fBClassName_4);
            _builder.append("::scm_anEIWith[] = {");
            String _join = IterableExtensions.join((Iterable)inputWith, (CharSequence)", ");
            _builder.append(_join);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const TForteInt16 ");
            CharSequence _fBClassName_5 = this.getFBClassName();
            _builder.append((Object)_fBClassName_5);
            _builder.append("::scm_anEIWithIndexes[] = {");
            String _join_1 = IterableExtensions.join((Iterable)inputWithIndexes, (CharSequence)", ");
            _builder.append(_join_1);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_6 = this.getFBClassName();
            _builder.append((Object)_fBClassName_6);
            _builder.append("::scm_anEventInputNames[] = {");
            CharSequence _fORTENameList_2 = this.getFORTENameList((List<? extends INamedElement>)this.getType().getInterfaceList().getEventInputs());
            _builder.append((Object)_fORTENameList_2);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty_3 = this.getType().getInterfaceList().getEventOutputs().isEmpty();
        boolean bl4 = _not_3 = !_isEmpty_3;
        if (_not_3) {
            _builder.append("const TDataIOID ");
            CharSequence _fBClassName_7 = this.getFBClassName();
            _builder.append((Object)_fBClassName_7);
            _builder.append("::scm_anEOWith[] = {");
            String _join_2 = IterableExtensions.join((Iterable)outputWith, (CharSequence)", ");
            _builder.append(_join_2);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const TForteInt16 ");
            CharSequence _fBClassName_8 = this.getFBClassName();
            _builder.append((Object)_fBClassName_8);
            _builder.append("::scm_anEOWithIndexes[] = {");
            String _join_3 = IterableExtensions.join((Iterable)outputWithIndexes, (CharSequence)", ");
            _builder.append(_join_3);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
            _builder.append("const CStringDictionary::TStringId ");
            CharSequence _fBClassName_9 = this.getFBClassName();
            _builder.append((Object)_fBClassName_9);
            _builder.append("::scm_anEventOutputNames[] = {");
            CharSequence _fORTENameList_3 = this.getFORTENameList((List<? extends INamedElement>)this.getType().getInterfaceList().getEventOutputs());
            _builder.append((Object)_fORTENameList_3);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (!this.getType().getInterfaceList().getSockets().isEmpty() || !this.getType().getInterfaceList().getPlugs().isEmpty()) {
            _builder.append("const SAdapterInstanceDef ");
            CharSequence _fBClassName_10 = this.getFBClassName();
            _builder.append((Object)_fBClassName_10);
            _builder.append("::scm_astAdapterInstances[] = {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            EList _sockets = this.getType().getInterfaceList().getSockets();
            EList _plugs = this.getType().getInterfaceList().getPlugs();
            Iterable _plus = Iterables.concat((Iterable)_sockets, (Iterable)_plugs);
            boolean _hasElements = false;
            for (AdapterDeclaration adapter : _plus) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n", "  ");
                }
                _builder.append("{");
                CharSequence _fORTEString = this.getFORTEString(adapter.getTypeName());
                _builder.append((Object)_fORTEString, "  ");
                _builder.append(", ");
                CharSequence _fORTEString_1 = this.getFORTEString(adapter.getName());
                _builder.append((Object)_fORTEString_1, "  ");
                _builder.append(", ");
                boolean _isIsInput = adapter.isIsInput();
                boolean _not_4 = !_isIsInput;
                _builder.append((Object)_not_4, "  ");
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateFBInterfaceSpecDeclaration() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("static const SFBInterfaceSpec scm_stFBInterfaceSpec;");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateFBInterfaceSpecDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SFBInterfaceSpec ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scm_stFBInterfaceSpec = {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size = this.getType().getInterfaceList().getEventInputs().size();
        _builder.append((Object)_size, "  ");
        _builder.append(", ");
        boolean _isEmpty = this.getType().getInterfaceList().getEventInputs().isEmpty();
        if (_isEmpty) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scm_anEventInputNames, scm_anEIWith, scm_anEIWithIndexes");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_1 = this.getType().getInterfaceList().getEventOutputs().size();
        _builder.append((Object)_size_1, "  ");
        _builder.append(", ");
        boolean _isEmpty_1 = this.getType().getInterfaceList().getEventOutputs().isEmpty();
        if (_isEmpty_1) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scm_anEventOutputNames, scm_anEOWith, scm_anEOWithIndexes");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_2 = this.getType().getInterfaceList().getInputVars().size();
        _builder.append((Object)_size_2, "  ");
        _builder.append(", ");
        boolean _isEmpty_2 = this.getType().getInterfaceList().getInputVars().isEmpty();
        if (_isEmpty_2) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scm_anDataInputNames, scm_anDataInputTypeIds");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_3 = this.getType().getInterfaceList().getOutputVars().size();
        _builder.append((Object)_size_3, "  ");
        _builder.append(", ");
        boolean _isEmpty_3 = this.getType().getInterfaceList().getInputVars().isEmpty();
        if (_isEmpty_3) {
            _builder.append("nullptr, nullptr");
        } else {
            _builder.append("scm_anDataOutputNames, scm_anDataOutputTypeIds");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_4 = this.getType().getInterfaceList().getPlugs().size();
        int _size_5 = this.getType().getInterfaceList().getSockets().size();
        int _plus = _size_4 + _size_5;
        _builder.append((Object)_plus, "  ");
        _builder.append(", ");
        if (!this.getType().getInterfaceList().getSockets().isEmpty() || !this.getType().getInterfaceList().getPlugs().isEmpty()) {
            _builder.append("scm_astAdapterInstances");
        } else {
            _builder.append("nullptr");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateAccessors(List<VarDeclaration> vars, String function) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration v : vars) {
            _builder.append("CIEC_");
            String _typeName = v.getTypeName();
            _builder.append(_typeName);
            _builder.append(" ");
            boolean _isArray = v.isArray();
            if (_isArray) {
                _builder.append("*");
            } else {
                _builder.append("&");
            }
            String _name = v.getName();
            _builder.append(_name);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            boolean _isArray_1 = v.isArray();
            if (_isArray_1) {
                _builder.append("  ");
                _builder.append("return static_cast<CIEC_");
                String _typeName_1 = v.getTypeName();
                _builder.append(_typeName_1, "  ");
                _builder.append("*>(static_cast<CIEC_ARRAY *>(");
                _builder.append(function, "  ");
                _builder.append("(");
                int _indexOf = vars.indexOf(v);
                _builder.append((Object)_indexOf, "  ");
                _builder.append("))[0]); //the first element marks the start of the array");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("  ");
                _builder.append("return *static_cast<CIEC_");
                String _typeName_2 = v.getTypeName();
                _builder.append(_typeName_2, "  ");
                _builder.append("*>(");
                _builder.append(function, "  ");
                _builder.append("(");
                int _indexOf_1 = vars.indexOf(v);
                _builder.append((Object)_indexOf_1, "  ");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateAccessors(List<AdapterDeclaration> adapters) {
        StringConcatenation _builder = new StringConcatenation();
        for (AdapterDeclaration adapter : adapters) {
            _builder.append("FORTE_");
            String _typeName = adapter.getTypeName();
            _builder.append(_typeName);
            _builder.append("& ");
            String _name = adapter.getName();
            _builder.append(_name);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("return (*static_cast<FORTE_");
            String _typeName_1 = adapter.getTypeName();
            _builder.append(_typeName_1, "  ");
            _builder.append("*>(m_apoAdapters[");
            int _indexOf = adapters.indexOf(adapter);
            _builder.append((Object)_indexOf, "  ");
            _builder.append("]));");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence getFORTENameList(List<? extends INamedElement> elements) {
        Functions.Function1 _function = it -> this.getFORTEString(it.getName());
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected CharSequence getFORTETypeList(List<? extends VarDeclaration> elements) {
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            boolean _isArray = it.isArray();
            if (_isArray) {
                CharSequence _fORTEString = this.getFORTEString("ARRAY");
                _builder.append((Object)_fORTEString);
                _builder.append(", ");
                int _arraySize = it.getArraySize();
                _builder.append((Object)_arraySize);
                _builder.append(", ");
            }
            CharSequence _fORTEString_1 = this.getFORTEString(it.getType().getName());
            _builder.append((Object)_fORTEString_1);
            return _builder.toString();
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(elements, (Functions.Function1)_function), (CharSequence)", ");
    }

    protected CharSequence getFBClassName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FORTE_");
        String _name = this.getType().getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence getFORTEString(String s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("g_nStringId");
        _builder.append(s);
        return _builder;
    }
}

