/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editparts.InstanceName;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementFigure;
import org.eclipse.fordiac.ide.application.policies.DeleteFBNElementEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.tools.ScrollingDragEditPartsTracker;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.VerifyListener;

public abstract class AbstractFBNElementEditPart
extends AbstractPositionableElementEditPart {
    private Device referencedDevice;
    private DiagramFontChangeListener fontChangeListener;
    private final ZoomManager zoomManager;
    private Adapter colorChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                AbstractFBNElementEditPart.this.backgroundColorChanged((IFigure)AbstractFBNElementEditPart.this.getFigure());
            }
        }
    };
    private final Adapter annotationContentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getI4DIACElement_Annotations()) {
                AbstractFBNElementEditPart.this.refreshName();
            }
        }
    };
    private IPropertyChangeListener listener;

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public AbstractFBNElementEditPart(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    public FBNetworkElementFigure getFigure() {
        return (FBNetworkElementFigure)super.getFigure();
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                AbstractFBNElementEditPart.this.refreshToolTip();
                if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getFBNetworkElement_Mapping()) {
                    AbstractFBNElementEditPart.this.updateDeviceListener();
                }
            }
        };
    }

    protected void updateDeviceListener() {
        Device device = this.findDevice();
        if (device != this.referencedDevice) {
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
            }
            this.referencedDevice = device;
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().add((Object)this.colorChangeListener);
            }
            this.backgroundColorChanged((IFigure)this.getFigure());
        }
    }

    public void activate() {
        super.activate();
        this.updateDeviceListener();
        if (this.getModel() != null) {
            this.getModel().eAdapters().add((Object)this.annotationContentAdapter);
        }
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        if (this.referencedDevice != null) {
            this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
        }
        if (this.getModel() != null) {
            this.getModel().eAdapters().remove((Object)this.annotationContentAdapter);
        }
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    public boolean isOnlyThisOrNothingSelected() {
        List selection = this.getViewer().getSelectedEditParts();
        if (selection.size() > 1) {
            return false;
        }
        if (selection.size() == 1) {
            return selection.get(0) == this;
        }
        return true;
    }

    protected void refreshToolTip() {
        this.getFigure().refreshToolTips();
    }

    protected void refreshComment() {
        this.refreshToolTip();
    }

    public FBNetworkElement getModel() {
        return (FBNetworkElement)super.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteFBNElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FBNElementSelectionPolicy());
        this.removeEditPolicy("DirectEditPolicy");
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = event -> {
                if (event.getProperty().equals("EventConnectionConnectorColor") || PreferenceConstants.isDataConnectorProperty((String)event.getProperty()) || event.getProperty().equals("AdapterConnectionConnectorColor")) {
                    this.getFigure().repaint();
                }
            };
        }
        return this.listener;
    }

    protected void backgroundColorChanged(IFigure figure) {
        Device dev;
        Color color = null;
        if (this.getModel() != null && (dev = this.findDevice()) != null) {
            color = LibraryElementFactory.eINSTANCE.createColor();
            color.setRed(dev.getColor().getRed());
            color.setGreen(dev.getColor().getGreen());
            color.setBlue(dev.getColor().getBlue());
        }
        this.setColor(figure, color);
    }

    private Device findDevice() {
        Resource res = null;
        if (this.getModel() != null && this.getModel().isMapped()) {
            res = this.getModel().getResource();
        }
        return res != null ? res.getDevice() : null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            this.getTargetFigure(interfaceEditPart).add(child, this.getInterfaceElementIndex(interfaceEditPart));
        } else {
            this.getFigure().add(child, new GridData(64), index);
        }
    }

    private IFigure getTargetFigure(InterfaceEditPart interfaceEditPart) {
        if (interfaceEditPart.isInput()) {
            if (interfaceEditPart.isEvent()) {
                return this.getFigure().getEventInputs();
            }
            if (interfaceEditPart.isAdapter()) {
                return this.getFigure().getSockets();
            }
            if (interfaceEditPart.isVariable()) {
                return this.getFigure().getDataInputs();
            }
        } else {
            if (interfaceEditPart.isEvent()) {
                return this.getFigure().getEventOutputs();
            }
            if (interfaceEditPart.isAdapter()) {
                return this.getFigure().getPlugs();
            }
            if (interfaceEditPart.isVariable()) {
                return this.getFigure().getDataOutputs();
            }
        }
        return this.getFigure();
    }

    private int getInterfaceElementIndex(InterfaceEditPart interfaceEditPart) {
        InterfaceList interfaceList = this.getModel().getInterface();
        if (interfaceEditPart.isInput()) {
            if (interfaceEditPart.isEvent()) {
                return interfaceList.getEventInputs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isAdapter()) {
                return interfaceList.getSockets().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isVariable()) {
                return interfaceList.getInputVars().indexOf((Object)interfaceEditPart.getModel());
            }
        } else {
            if (interfaceEditPart.isEvent()) {
                return interfaceList.getEventOutputs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isAdapter()) {
                return interfaceList.getPlugs().indexOf((Object)interfaceEditPart.getModel());
            }
            if (interfaceEditPart.isVariable()) {
                return interfaceList.getOutputVars().indexOf((Object)interfaceEditPart.getModel());
            }
        }
        return -1;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            this.getTargetFigure(interfaceEditPart).remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(new InstanceName(this.getModel()));
        elements.addAll((Collection<Object>)this.getModel().getInterface().getAllInterfaceElements());
        return elements;
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    protected void performDirectEdit() {
    }

    public Label getNameLabel() {
        return null;
    }

    protected void refreshName() {
    }

    protected DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getNameLabel(), (VerifyListener)new IdentifierVerifyListener());
    }

    public void setTransparency(int value) {
        for (Object ep : this.getChildren()) {
            if (!(ep instanceof AbstractViewEditPart)) continue;
            ((AbstractViewEditPart)ep).setTransparency(value);
        }
        super.setTransparency(value);
    }

    public DragTracker getDragTracker(Request request) {
        return new ScrollingDragEditPartsTracker((EditPart)this);
    }
}

