/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.ChangeSubAppIETypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InterfaceElementSection
extends org.eclipse.fordiac.ide.gef.properties.InterfaceElementSection {
    private TreeViewer connectionsTree;
    private Group group;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConnectionDisplaySection(parent);
    }

    private void createConnectionDisplaySection(Composite parent) {
        this.group = this.getWidgetFactory().createGroup(parent, Messages.InterfaceElementSection_ConnectionGroup);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionsTree = new TreeViewer((Composite)this.group, 772);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 100;
        gridData.widthHint = 80;
        this.connectionsTree.getTree().setLayoutData((Object)gridData);
        this.connectionsTree.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.connectionsTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        this.connectionsTree.setAutoExpandLevel(-1);
        new AdapterFactoryTreeEditor(this.connectionsTree.getTree(), (AdapterFactory)this.getAdapterFactory());
        Button delConnection = this.getWidgetFactory().createButton((Composite)this.group, "", 8);
        delConnection.setLayoutData((Object)new GridData(131072, 1024, false, true));
        delConnection.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        delConnection.setToolTipText(Messages.InterfaceElementSection_DeleteConnectionToolTip);
        delConnection.addListener(13, event -> {
            Object selection = ((TreeSelection)this.connectionsTree.getSelection()).getFirstElement();
            if (selection instanceof Connection) {
                this.executeCommand((Command)new DeleteConnectionCommand((Connection)selection));
                this.connectionsTree.refresh();
            }
        });
    }

    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            if (this.getType().isIsInput()) {
                this.group.setText(Messages.InterfaceElementSection_InConnections);
            } else {
                this.group.setText(Messages.InterfaceElementSection_OutConnections);
            }
            this.connectionsTree.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected void setInputCode() {
        this.connectionsTree.setInput(null);
    }

    protected ChangeTypeCommand newChangeTypeCommand(VarDeclaration data, DataType newType) {
        return new ChangeSubAppIETypeCommand(data, newType);
    }

    private static class ConnectionContentProvider
    implements ITreeContentProvider {
        private IInterfaceElement element;

        private ConnectionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IInterfaceElement) {
                this.element = (IInterfaceElement)inputElement;
                if (this.element.isIsInput() && this.element.getFBNetworkElement() != null || !this.element.isIsInput() && this.element.getFBNetworkElement() == null) {
                    return this.element.getInputConnections().toArray();
                }
                return this.element.getOutputConnections().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Connection) {
                Object[] objects = new Object[2];
                if (this.element.isIsInput()) {
                    objects[0] = ((Connection)parentElement).getSourceElement() != null ? ((Connection)parentElement).getSourceElement() : this.element;
                    objects[1] = ((Connection)parentElement).getSource();
                } else {
                    objects[0] = ((Connection)parentElement).getDestinationElement() != null ? ((Connection)parentElement).getDestinationElement() : this.element;
                    objects[1] = ((Connection)parentElement).getDestination();
                }
                return objects;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Connection) {
                return this.element;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Connection) {
                return ((Connection)element).getSource() != null && ((Connection)element).getDestination() != null;
            }
            return false;
        }
    }
}

