/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.filter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.forte_lua.filter.LuaConstants;
import org.eclipse.fordiac.ide.export.forte_lua.filter.STAlgorithmFilter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BasicFBFilter {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> errors = new ArrayList<String>();
    private STAlgorithmFilter stAlgorithmFilter = new STAlgorithmFilter();

    public CharSequence lua(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaConstants = LuaConstants.luaConstants(type);
        _builder.append((Object)_luaConstants);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaAlgorithms = this.luaAlgorithms(type);
        _builder.append((Object)_luaAlgorithms);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaStates = this.luaStates(type.getECC());
        _builder.append((Object)_luaStates);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaECC = this.luaECC(type.getECC(), this.getVariables(type));
        _builder.append((Object)_luaECC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaInterfaceSpec = LuaConstants.luaInterfaceSpec(type.getInterfaceList());
        _builder.append((Object)_luaInterfaceSpec);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaInternalVarsInformation = LuaConstants.luaInternalVarsInformation(type);
        _builder.append((Object)_luaInternalVarsInformation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("return {ECC = executeEvent, interfaceSpec = interfaceSpec, internalVarsInformation = internalVarsInformation}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence luaECC(ECC ecc, Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function transition(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("local ");
        CharSequence _luaStateVariable = LuaConstants.luaStateVariable();
        _builder.append((Object)_luaStateVariable, "  ");
        _builder.append(" = ");
        CharSequence _luaFBStateVariable = LuaConstants.luaFBStateVariable();
        _builder.append((Object)_luaFBStateVariable, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaFBVariablesPrefix = LuaConstants.luaFBVariablesPrefix(variables);
        _builder.append((Object)_luaFBVariablesPrefix, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaTransitions = this.luaTransitions(ecc);
        _builder.append((Object)_luaTransitions, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        _builder.newLine();
        _builder.append("local function executeEvent(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("local modified = transition(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("while modified do");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("modified = transition(fb, -1)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("end");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    private Iterable<VarDeclaration> getVariables(BasicFBType type) {
        EList _inputVars = type.getInterfaceList().getInputVars();
        EList _outputVars = type.getInterfaceList().getOutputVars();
        Iterable _plus = Iterables.concat((Iterable)_inputVars, (Iterable)_outputVars);
        EList _internalVars = type.getInternalVars();
        return Iterables.concat((Iterable)_plus, (Iterable)_internalVars);
    }

    private CharSequence luaTransitions(ECC ecc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ecc.getECState();
        boolean _hasElements = false;
        for (ECState state : _eCState) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "");
            }
            CharSequence _luaStateName = LuaConstants.luaStateName(state);
            _builder.append((Object)_luaStateName);
            _builder.append(" == ");
            CharSequence _luaStateVariable = LuaConstants.luaStateVariable();
            _builder.append((Object)_luaStateVariable);
            _builder.append(" then");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _luaTransition = this.luaTransition(state);
            _builder.append((Object)_luaTransition, "  ");
        }
        if (_hasElements) {
            _builder.append("\nelse return false\nend");
        }
        return _builder;
    }

    private CharSequence luaTransition(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outTransitions = state.getOutTransitions();
        boolean _hasElements = false;
        for (ECTransition tran : _outTransitions) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "");
            }
            CharSequence _luaTransitionCondition = this.luaTransitionCondition(tran);
            _builder.append((Object)_luaTransitionCondition);
            _builder.append(" then return enter");
            CharSequence _luaStateName = LuaConstants.luaStateName(tran.getDestination());
            _builder.append((Object)_luaStateName);
            _builder.append("(fb)");
        }
        if (_hasElements) {
            _builder.append("\nelse return false\nend");
        }
        return _builder;
    }

    private CharSequence luaTransitionCondition(ECTransition tran) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Event _conditionEvent = tran.getConditionEvent();
        boolean bl = _notEquals = !Objects.equal((Object)_conditionEvent, null);
        if (_notEquals) {
            CharSequence _luaInputEventName = LuaConstants.luaInputEventName(tran.getConditionEvent());
            _builder.append((Object)_luaInputEventName);
            _builder.append(" == id");
        } else {
            _builder.append("true");
        }
        _builder.append(" and ");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)tran.getConditionExpression());
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            CharSequence _luaTransitionConditionExpression = this.luaTransitionConditionExpression(tran);
            _builder.append((Object)_luaTransitionConditionExpression);
        } else {
            _builder.append("true");
        }
        return _builder;
    }

    private CharSequence luaTransitionConditionExpression(ECTransition tran) {
        CharSequence _xblockexpression = null;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)tran);
        BasicFBType type = (BasicFBType)_rootContainer;
        _xblockexpression = this.stAlgorithmFilter.lua(type, tran.getConditionExpression());
        return _xblockexpression;
    }

    private CharSequence luaStates(ECC ecc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ecc.getECState();
        for (ECState state : _eCState) {
            CharSequence _luaState = this.luaState(state);
            _builder.append((Object)_luaState);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence luaState(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function enter");
        CharSequence _luaStateName = LuaConstants.luaStateName(state);
        _builder.append((Object)_luaStateName);
        _builder.append("(fb)");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaFBStateVariable = LuaConstants.luaFBStateVariable();
        _builder.append((Object)_luaFBStateVariable, "  ");
        _builder.append(" = ");
        CharSequence _luaStateName_1 = LuaConstants.luaStateName(state);
        _builder.append((Object)_luaStateName_1, "  ");
        _builder.newLineIfNotEmpty();
        EList _eCAction = state.getECAction();
        for (ECAction action : _eCAction) {
            boolean _notEquals;
            _builder.append("  ");
            Algorithm _algorithm = action.getAlgorithm();
            boolean bl = _notEquals = !Objects.equal(null, (Object)_algorithm);
            if (_notEquals) {
                CharSequence _luaAlgorithmName = LuaConstants.luaAlgorithmName(action.getAlgorithm());
                _builder.append((Object)_luaAlgorithmName, "  ");
                _builder.append("(fb)");
            }
            _builder.newLineIfNotEmpty();
            Event _output = action.getOutput();
            if (_output instanceof AdapterEvent) {
                _builder.append("  ");
                Event _output_1 = action.getOutput();
                CharSequence _luaSendAdapterOutputEvent = null;
                if (_output_1 != null) {
                    _luaSendAdapterOutputEvent = LuaConstants.luaSendAdapterOutputEvent(_output_1);
                }
                _builder.append((Object)_luaSendAdapterOutputEvent, "  ");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("  ");
            Event _output_2 = action.getOutput();
            CharSequence _luaSendOutputEvent = null;
            if (_output_2 != null) {
                _luaSendOutputEvent = LuaConstants.luaSendOutputEvent(_output_2);
            }
            _builder.append((Object)_luaSendOutputEvent, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("return true");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    private CharSequence luaAlgorithms(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        EList _algorithm = type.getAlgorithm();
        for (Algorithm alg : _algorithm) {
            String _luaAlgorithm = this.luaAlgorithm(alg);
            _builder.append(_luaAlgorithm);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private String _luaAlgorithm(Algorithm alg) {
        Class<?> _class = alg.getClass();
        String _plus = "Cannot export algorithm " + _class;
        throw new UnsupportedOperationException(_plus);
    }

    private String _luaAlgorithm(STAlgorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function ");
        CharSequence _luaAlgorithmName = LuaConstants.luaAlgorithmName((Algorithm)alg);
        _builder.append((Object)_luaAlgorithmName);
        _builder.append("(fb)");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        String _lua = this.stAlgorithmFilter.lua(alg);
        _builder.append(_lua, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        String result = _builder.toString();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Error in algorithm ");
            String _name = alg.getName();
            _builder_1.append(_name);
            _builder_1.append(": ");
            _builder_1.append(it);
            return _builder_1.toString();
        };
        this.errors.addAll(ListExtensions.map(this.stAlgorithmFilter.getErrors(), (Functions.Function1)_function));
        this.stAlgorithmFilter.getErrors().clear();
        return result;
    }

    private String luaAlgorithm(Algorithm alg) {
        if (alg instanceof STAlgorithm) {
            return this._luaAlgorithm((STAlgorithm)alg);
        }
        if (alg != null) {
            return this._luaAlgorithm(alg);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(alg).toString());
    }

    @Pure
    public List<String> getErrors() {
        return this.errors;
    }
}

