/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.PrimitiveConnection;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.PrimitiveFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.DeletePrimitiveEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.policies.ChangeStringEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.IChangeStringEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;

public abstract class PrimitiveEditPart
extends AbstractDirectEditableEditPart
implements NodeEditPart,
IChangeStringEditPart {
    private final PrimitiveConnection connection;
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (PrimitiveEditPart.this.getCastedModel().eAdapters().contains((Object)PrimitiveEditPart.this.adapter)) {
                PrimitiveEditPart.this.refresh();
            }
        }
    };

    public PrimitiveEditPart(PrimitiveConnection connection) {
        this.connection = connection;
    }

    public void activate() {
        if (!this.isActive()) {
            this.getCastedModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    public PrimitiveConnection getPrimitiveConnection() {
        return this.connection;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PrimitiveFigure figure = (PrimitiveFigure)this.getFigure();
        if (this.getCastedModel() != null) {
            figure.setLabelText(this.getCastedModel().getEvent());
            figure.setInterfaceDirection(this.isLeftInterface());
        }
    }

    public Primitive getCastedModel() {
        return (Primitive)this.getModel();
    }

    protected TransactionEditPart getCastedParent() {
        return (TransactionEditPart)this.getParent();
    }

    protected boolean isLeftInterface() {
        return this.getCastedModel().getInterface().getName().equals(((Service)this.getCastedModel().eContainer().eContainer().eContainer()).getLeftInterface().getName());
    }

    protected IFigure createFigure() {
        return new PrimitiveFigure(this.isLeftInterface(), this.getCastedModel().getEvent());
    }

    public Label getNameLabel() {
        return ((PrimitiveFigure)this.getFigure()).getLabel();
    }

    public Figure getCenterFigure() {
        return ((PrimitiveFigure)this.getFigure()).getCenterFigure();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeletePrimitiveEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ChangeStringEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
    }
}

