/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.ChangeInterfaceNameEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.EmptyXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class SequenceRootEditPart
extends AbstractGraphicalEditPart {
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (SequenceRootEditPart.this.getCastedModel().eAdapters().contains((Object)SequenceRootEditPart.this.adapter)) {
                SequenceRootEditPart.this.refresh();
            }
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.getCastedModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        return new ServiceFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EmptyXYLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ChangeInterfaceNameEditPolicy());
    }

    public boolean isLeft(DirectEditRequest request) {
        Point point = request.getLocation() == null ? new Point(request.getCellEditor().getControl().getLocation()) : request.getLocation().getCopy();
        this.getFigure().translateToRelative((Translatable)point);
        return point.x < this.getFigure().getClientArea().width / 2;
    }

    public DirectEditManager getManager(boolean isLeft) {
        Label l = isLeft ? ((ServiceFigure)this.getFigure()).getLeftLabel() : ((ServiceFigure)this.getFigure()).getRightLabel();
        return new LabelDirectEditManager((GraphicalEditPart)this, l);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && request instanceof DirectEditRequest) {
            this.performDirectEdit(this.isLeft((DirectEditRequest)request));
        } else {
            super.performRequest(request);
        }
    }

    public void performDirectEdit(char initialCharacter, boolean isLeft) {
        if (this.getManager(isLeft) instanceof LabelDirectEditManager) {
            ((LabelDirectEditManager)this.getManager(isLeft)).show(initialCharacter);
        } else {
            this.performDirectEdit(isLeft);
        }
    }

    public void performDirectEdit(boolean isLeft) {
        this.getManager(isLeft).show();
    }

    public Service getCastedModel() {
        return ((FBType)this.getModel()).getService();
    }

    public FBType getFBType() {
        return (FBType)this.getModel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ServiceFigure figure = (ServiceFigure)this.getFigure();
        if (this.getCastedModel() != null) {
            if (this.getCastedModel().getLeftInterface() != null) {
                figure.setLeftLabelText(this.getCastedModel().getLeftInterface() != null ? this.getCastedModel().getLeftInterface().getName() : "");
            }
            if (this.getCastedModel().getRightInterface() != null) {
                figure.setRightLabelText(this.getCastedModel().getRightInterface() != null ? this.getCastedModel().getRightInterface().getName() : "");
            }
        }
    }

    protected List<?> getModelChildren() {
        ArrayList children = new ArrayList();
        if (this.getCastedModel().getServiceSequence() != null) {
            children.addAll(this.getCastedModel().getServiceSequence());
        }
        return children;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof ServiceSequenceEditPart) {
            ServiceSequenceEditPart.ServiceSequenceFigure child = (ServiceSequenceEditPart.ServiceSequenceFigure)((GraphicalEditPart)childEditPart).getFigure();
            ServiceFigure thisFigure = (ServiceFigure)this.getFigure();
            GridData childData = new GridData();
            childData.grabExcessHorizontalSpace = true;
            childData.horizontalAlignment = 4;
            thisFigure.getServiceSequenceContainer().add((IFigure)child);
            thisFigure.getServiceSequenceContainer().getLayoutManager().setConstraint((IFigure)child, (Object)childData);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof ServiceSequenceEditPart) {
            ServiceSequenceEditPart.ServiceSequenceFigure child = (ServiceSequenceEditPart.ServiceSequenceFigure)((GraphicalEditPart)childEditPart).getFigure();
            ServiceFigure thisFigure = (ServiceFigure)this.getFigure();
            thisFigure.getServiceSequenceContainer().remove((IFigure)child);
        }
    }

    public static class ServiceFigure
    extends FreeformLayeredPane {
        private Figure leftFigure;
        private Figure middleFigure;
        private Figure rightFigure;
        private Label leftLabel;
        private Label rightLabel;
        private Layer serviceSequenceContainer;

        public ServiceFigure() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setForegroundColor(ColorConstants.blue);
            this.createBaseLayer();
            this.createInterfaceLayer();
            this.createServiceSequenceLayer();
        }

        private void createBaseLayer() {
            Layer baseLayer = new Layer();
            baseLayer.setBorder((Border)new MarginBorder(0, 10, 0, 10));
            GridLayout layout = new GridLayout(3, false);
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            baseLayer.setLayoutManager((LayoutManager)layout);
            this.leftFigure = new Figure();
            GridLayout leftLayout = new GridLayout();
            this.leftFigure.setLayoutManager((LayoutManager)leftLayout);
            leftLayout.horizontalSpacing = 0;
            leftLayout.marginWidth = 0;
            leftLayout.marginHeight = 0;
            leftLayout.verticalSpacing = 0;
            baseLayer.add((IFigure)this.leftFigure);
            this.middleFigure = new Figure();
            this.middleFigure.setPreferredSize(37, 0);
            this.middleFigure.setBorder((Border)new AdvancedLineBorder(24));
            baseLayer.add((IFigure)this.middleFigure);
            this.rightFigure = new Figure();
            GridLayout rightLayout = new GridLayout();
            this.rightFigure.setLayoutManager((LayoutManager)rightLayout);
            rightLayout.horizontalSpacing = 0;
            rightLayout.marginWidth = 0;
            rightLayout.marginHeight = 0;
            rightLayout.verticalSpacing = 0;
            baseLayer.add((IFigure)this.rightFigure);
            GridData leftGridData = new GridData();
            leftGridData.horizontalAlignment = 4;
            leftGridData.verticalAlignment = 4;
            leftGridData.grabExcessVerticalSpace = true;
            leftGridData.grabExcessHorizontalSpace = true;
            GridData middleGridData = new GridData();
            middleGridData.verticalAlignment = 4;
            middleGridData.grabExcessVerticalSpace = true;
            GridData rightGridData = new GridData();
            rightGridData.horizontalAlignment = 4;
            rightGridData.verticalAlignment = 4;
            rightGridData.grabExcessVerticalSpace = true;
            rightGridData.grabExcessHorizontalSpace = true;
            layout.setConstraint((IFigure)this.middleFigure, (Object)middleGridData);
            layout.setConstraint((IFigure)this.leftFigure, (Object)leftGridData);
            layout.setConstraint((IFigure)this.rightFigure, (Object)rightGridData);
            this.add((IFigure)baseLayer);
        }

        private void createInterfaceLayer() {
            Layer interfaceLayer = new Layer();
            interfaceLayer.setBorder((Border)new MarginBorder(5, 0, 0, 0));
            GridLayout layout = new GridLayout(2, true);
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            interfaceLayer.setLayoutManager((LayoutManager)layout);
            this.leftLabel = new Label();
            this.leftLabel.setLabelAlignment(4);
            this.leftLabel.setBorder((Border)new MarginBorder(5, 0, 0, 35));
            GridData leftLabelData = new GridData();
            leftLabelData.grabExcessHorizontalSpace = true;
            leftLabelData.horizontalAlignment = 4;
            interfaceLayer.getLayoutManager().setConstraint((IFigure)this.leftLabel, (Object)leftLabelData);
            interfaceLayer.add((IFigure)this.leftLabel);
            this.rightLabel = new Label();
            this.rightLabel.setLabelAlignment(1);
            this.rightLabel.setBorder((Border)new MarginBorder(5, 35, 0, 0));
            GridData rightLabelData = new GridData();
            rightLabelData.grabExcessHorizontalSpace = true;
            rightLabelData.horizontalAlignment = 4;
            interfaceLayer.getLayoutManager().setConstraint((IFigure)this.rightLabel, (Object)rightLabelData);
            interfaceLayer.add((IFigure)this.rightLabel);
            this.add((IFigure)interfaceLayer);
        }

        private void createServiceSequenceLayer() {
            this.serviceSequenceContainer = new Layer();
            this.serviceSequenceContainer.setBorder((Border)new MarginBorder(20, 10, 5, 10));
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            this.serviceSequenceContainer.setLayoutManager((LayoutManager)layout);
            this.add((IFigure)this.serviceSequenceContainer);
        }

        public Figure getLeftFigure() {
            return this.leftFigure;
        }

        public Figure getMiddleFigure() {
            return this.middleFigure;
        }

        public Figure getRightFigure() {
            return this.rightFigure;
        }

        public Label getLeftLabel() {
            return this.leftLabel;
        }

        public Label getRightLabel() {
            return this.rightLabel;
        }

        public Layer getServiceSequenceContainer() {
            return this.serviceSequenceContainer;
        }

        public void setLeftLabelText(String name) {
            this.leftLabel.setText(name != null ? name : "");
        }

        public void setRightLabelText(String name) {
            this.rightLabel.setText(name != null ? name : "");
        }
    }
}

