/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveInterfaceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveParameterCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.PrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PrimitiveSection
extends AbstractServiceSection {
    private Text eventText;
    private Text parametersText;
    private CCombo serviceInterfaceCombo;
    private Button buttonNone;
    private Button buttonTrue;
    private Button buttonFalse;
    private Group qiGroup;
    protected PrimitiveEditPart editPart;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createEventSection(this.getLeftComposite());
        this.createPrimitiveSection(this.getLeftComposite());
        this.createQISection(this.getRightComposite());
    }

    protected void createEventSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.PrimitiveSection_CreateEventSection_Event);
        this.eventText = this.createGroupText(composite, true);
        this.eventText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrimitiveSection.this.removeContentAdapter();
                PrimitiveSection.this.executeCommand(new ChangePrimitiveEventCommand(PrimitiveSection.this.getType(), PrimitiveSection.this.eventText.getText()));
                PrimitiveSection.this.setRadioButton();
                PrimitiveSection.this.addContentAdapter();
            }
        });
    }

    protected void createQISection(Composite parent) {
        this.qiGroup = this.getWidgetFactory().createGroup(parent, "QI");
        this.qiGroup.setLayout((Layout)new RowLayout(512));
        this.qiGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.buttonNone = this.getWidgetFactory().createButton((Composite)this.qiGroup, Messages.PrimitiveSection_None, 16);
        this.buttonNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PrimitiveSection.this.changeEventText(Messages.PrimitiveSection_None);
                PrimitiveSection.this.refresh();
            }
        });
        this.buttonTrue = this.getWidgetFactory().createButton((Composite)this.qiGroup, "true", 16);
        this.buttonTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PrimitiveSection.this.changeEventText("true");
                PrimitiveSection.this.refresh();
            }
        });
        this.buttonFalse = this.getWidgetFactory().createButton((Composite)this.qiGroup, "false", 16);
        this.buttonFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PrimitiveSection.this.changeEventText("false");
                PrimitiveSection.this.refresh();
            }
        });
        this.qiGroup.setVisible(false);
    }

    private void changeEventText(String button) {
        block10: {
            if (this.editPart == null) break block10;
            String event = this.getType().getEvent().replace("+", "").replace("-", "");
            switch (button) {
                case "true": {
                    this.editPart.getNameLabel().setText(String.valueOf(event) + "+");
                    this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), String.valueOf(event) + "+"));
                    break;
                }
                case "false": {
                    this.editPart.getNameLabel().setText(String.valueOf(event) + "-");
                    this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), String.valueOf(event) + "-"));
                    break;
                }
                default: {
                    this.editPart.getNameLabel().setText(event);
                    this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), event));
                }
            }
        }
    }

    protected void createPrimitiveSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.PrimitiveSection_CreatePrimitiveSection_Interface);
        this.serviceInterfaceCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)composite);
        this.serviceInterfaceCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.serviceInterfaceCombo.addListener(13, event -> {
            this.executeCommand(new ChangePrimitiveInterfaceCommand((Service)this.getType().eContainer().eContainer().eContainer(), this.getType(), this.serviceInterfaceCombo.getText()));
            this.refresh();
        });
        this.getWidgetFactory().createCLabel(composite, Messages.PrimitiveSection_CreatePrimitiveSection_Parameters);
        this.parametersText = this.createGroupText(composite, true);
        this.parametersText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrimitiveSection.this.removeContentAdapter();
                PrimitiveSection.this.executeCommand(new ChangePrimitiveParameterCommand(PrimitiveSection.this.getType(), PrimitiveSection.this.parametersText.getText()));
                PrimitiveSection.this.addContentAdapter();
            }
        });
    }

    protected Primitive getInputType(Object input) {
        if (input instanceof InputPrimitiveEditPart || input instanceof OutputPrimitiveEditPart) {
            this.editPart = (PrimitiveEditPart)((Object)input);
            return ((PrimitiveEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof InputPrimitive || input instanceof OutputPrimitive) {
            IEditorPart editor = EditorUtils.getCurrentActiveEditor();
            GraphicalViewer view = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            this.editPart = (PrimitiveEditPart)((Object)view.getEditPartRegistry().get(input));
            return (Primitive)input;
        }
        return null;
    }

    protected void setInputCode() {
        this.parametersText.setEnabled(false);
        this.serviceInterfaceCombo.removeAll();
        this.eventText.setEnabled(false);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.parametersText.setText(this.getType().getParameters() != null ? this.getType().getParameters() : "");
            this.setServiceInterfaceDropdown();
            this.eventText.setText(this.getType().getEvent());
            if (this.containsQI()) {
                this.setRadioButton();
                if (this.type instanceof OutputPrimitive) {
                    this.qiGroup.setText("QO");
                } else {
                    this.qiGroup.setText("QI");
                }
                this.qiGroup.setVisible(true);
            }
        }
        this.commandStack = commandStackBuffer;
    }

    protected Primitive getType() {
        return (Primitive)this.type;
    }

    protected FBType getFB() {
        return (FBType)this.getType().eContainer().eContainer().eContainer().eContainer();
    }

    protected boolean containsQI() {
        block3: {
            block2: {
                if (!(this.type instanceof InputPrimitive)) break block2;
                for (VarDeclaration var : this.getFB().getInterfaceList().getInputVars()) {
                    if (!var.getName().equals("QI")) continue;
                    return true;
                }
                break block3;
            }
            if (!(this.type instanceof OutputPrimitive)) break block3;
            for (VarDeclaration var : this.getFB().getInterfaceList().getOutputVars()) {
                if (!var.getName().equals("QO")) continue;
                return true;
            }
        }
        return false;
    }

    public void setRadioButton() {
        if (this.getType().getEvent().endsWith("+")) {
            this.buttonTrue.setSelection(true);
            this.buttonFalse.setSelection(false);
            this.buttonNone.setSelection(false);
        } else if (this.getType().getEvent().endsWith("-")) {
            this.buttonFalse.setSelection(true);
            this.buttonNone.setSelection(false);
            this.buttonTrue.setSelection(false);
        } else {
            this.buttonNone.setSelection(true);
            this.buttonFalse.setSelection(false);
            this.buttonTrue.setSelection(false);
        }
    }

    protected boolean isLeftInterfaceSelected() {
        return this.serviceInterfaceCombo.getText().equals(this.serviceInterfaceCombo.getItem(0));
    }

    public void setServiceInterfaceDropdown() {
        this.serviceInterfaceCombo.removeAll();
        Service s = (Service)this.getType().eContainer().eContainer().eContainer();
        this.serviceInterfaceCombo.add(s.getLeftInterface().getName());
        this.serviceInterfaceCombo.add(s.getRightInterface().getName());
        if (this.serviceInterfaceCombo.getItem(0).equals(this.getType().getInterface().getName())) {
            this.serviceInterfaceCombo.select(0);
        } else {
            this.serviceInterfaceCombo.select(1);
        }
    }

    protected void setInputInit() {
    }
}

