/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Path;

public class ECTransitionFigure
extends PolylineConnection {
    private static final double TRANSITION_CONTROL_POINT_VECTOR_LENGTH = 0.3;
    private Label condition;
    private final TransitionOrderDecorator transitionOrderDecorator;

    public ECTransitionFigure(ECTransition ecTransition) {
        this.setAntialias(1);
        this.setForegroundColor(PreferenceGetter.getColor("ECCEditorTransitionColor"));
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        this.updateBendPoints(ecTransition);
        this.transitionOrderDecorator = new TransitionOrderDecorator();
        this.setSourceDecoration(this.transitionOrderDecorator);
        this.createConditionLabel(ecTransition.getConditionText());
        this.setTargetDecoration((RotatableDecoration)ECTransitionFigure.createTargetDecorator());
    }

    public void setConditionText(String conditionText) {
        this.condition.setText(conditionText);
    }

    public void updateBendPoints(ECTransition ecTransition) {
        ArrayList<AbsoluteBendpoint> bendPoints = new ArrayList<AbsoluteBendpoint>();
        bendPoints.add(new AbsoluteBendpoint(ecTransition.getX(), ecTransition.getY()));
        this.getConnectionRouter().setConstraint((Connection)this, bendPoints);
    }

    public void setTransitionOrder(String value) {
        this.transitionOrderDecorator.setText(value);
    }

    private static PolygonDecoration createTargetDecorator() {
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        rectDec.setScale(7.0, 4.0);
        rectDec.setFill(true);
        return rectDec;
    }

    private void createConditionLabel(String conditionText) {
        this.condition = new Label(conditionText);
        this.condition.setBorder((Border)new MarginBorder(3, 6, 3, 6));
        this.condition.setOpaque(true);
        this.add((IFigure)this.condition, new ConnectionLocator((Connection)this, 4));
    }

    protected void outlineShape(Graphics g) {
        Path p = this.getPath();
        g.drawPath(p);
        p.dispose();
    }

    public Rectangle getBounds() {
        float[] pathBounds = new float[4];
        Path p = this.getPath();
        p.getBounds(pathBounds);
        p.dispose();
        Rectangle pathRect = new Rectangle((int)pathBounds[0], (int)pathBounds[1], (int)pathBounds[2], (int)pathBounds[3]);
        return super.getBounds().getUnion(pathRect);
    }

    private Path getPath() {
        Path p = new Path(null);
        if (3 == this.getPoints().size()) {
            p.moveTo((float)this.getStart().x, (float)this.getStart().y);
            Vector startEnd = new Vector((double)((float)this.getEnd().x - (float)this.getStart().x), (double)((float)this.getEnd().y - (float)this.getStart().y));
            Vector startMid = new Vector((double)((float)this.getPoints().getMidpoint().x - (float)this.getStart().x), (double)((float)this.getPoints().getMidpoint().y - (float)this.getStart().y));
            Vector midEnd = new Vector((double)((float)this.getEnd().x - (float)this.getPoints().getMidpoint().x), (double)((float)this.getEnd().y - (float)this.getPoints().getMidpoint().y));
            Vector startEndNorm = startEnd.getDivided(startEnd.getLength() < 1.0E-4 ? 1.0 : startEnd.getLength());
            Vector startEnd30 = startEndNorm.getMultiplied(startMid.getLength() * 0.3);
            Vector startMid30 = startMid.getMultiplied(0.3);
            Vector midEnd30 = midEnd.getMultiplied(0.3);
            p.cubicTo((float)this.getStart().x + (float)startMid30.x, (float)this.getStart().y + (float)startMid30.y, (float)this.getPoints().getMidpoint().x - (float)startEnd30.x, (float)this.getPoints().getMidpoint().y - (float)startEnd30.y, (float)this.getPoints().getMidpoint().x, (float)this.getPoints().getMidpoint().y);
            p.cubicTo((float)this.getPoints().getMidpoint().x + (float)startEnd30.x, (float)this.getPoints().getMidpoint().y + (float)startEnd30.y, (float)this.getEnd().x - (float)midEnd30.x, (float)this.getEnd().y - (float)midEnd30.y, (float)this.getEnd().x, (float)this.getEnd().y);
        }
        return p;
    }

    private class TransitionOrderDecorator
    extends Ellipse
    implements RotatableDecoration {
        private static final int TRANSITON_ORDER_LABEL_FONT_SIZE = 7;
        private static final String TRANSITION_ORDER_LABEL_FONT = "TransitionOrderLabelFont";
        private final Label orderLabel;

        public TransitionOrderDecorator() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setFill(true);
            this.setAntialias(1);
            this.setBackgroundColor(PreferenceGetter.getColor("ECCEditorTransitionColor"));
            this.setOutline(false);
            this.orderLabel = new Label();
            this.orderLabel.setOpaque(false);
            this.orderLabel.setForegroundColor(ColorConstants.white);
            this.orderLabel.setFont(this.getOrderLabelFont());
            this.add((IFigure)this.orderLabel);
        }

        private Font getOrderLabelFont() {
            FontData[] fontData = (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.fordiac.ide.preferences.diagramFontDefinition").clone();
            Arrays.stream(fontData).forEach(fd -> fd.setHeight(7));
            JFaceResources.getFontRegistry().put(TRANSITION_ORDER_LABEL_FONT, fontData);
            return JFaceResources.getFont((String)TRANSITION_ORDER_LABEL_FONT);
        }

        public void setReferencePoint(Point p) {
        }

        public void setLocation(Point p) {
            p.x -= this.getSize().width() / 2;
            p.y -= this.getSize().height() / 2;
            super.setLocation(p);
        }

        public void setText(String val) {
            this.orderLabel.setText(val);
            if ("".equals(this.orderLabel.getText())) {
                this.setSize(0, 0);
            } else {
                int dim = this.orderLabel.getFont().getFontData()[0].getHeight() * 2;
                this.setSize(dim, dim);
            }
        }
    }
}

