/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class SelectFBTypesWizardPage
extends WizardExportResourcesPage {
    private static final String NAME = "name";
    private static final String SORT_INDEX = "sortIndex";
    private Combo destinationNameField;
    private Button overwrite;
    private static final String STORE_DIRECTORY_NAMES_ID = "SelectFBTypesWizardPage.STORE_DIRECTORY_NAMES_ID";
    private static final String STORE_CURRENT_FILTER_SELECTION_ID = "SelectFBTypesWizardPage.STORE_CURRENT_FILTER_SELECTION_ID";
    private final List<IConfigurationElement> exportFilters = new ArrayList<IConfigurationElement>();
    private Combo filters;

    protected SelectFBTypesWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    private void addAvailableExportFilter(Group group) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.export.exportFilter");
        Arrays.sort(elems, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                int sortIndex1 = 0;
                try {
                    sortIndex1 = Integer.parseInt(o1.getAttribute(SelectFBTypesWizardPage.SORT_INDEX));
                }
                catch (NumberFormatException numberFormatException) {}
                int sortIndex2 = 0;
                try {
                    sortIndex2 = Integer.parseInt(o2.getAttribute(SelectFBTypesWizardPage.SORT_INDEX));
                }
                catch (NumberFormatException numberFormatException) {}
                return sortIndex1 - sortIndex2;
            }
        });
        this.exportFilters.clear();
        this.exportFilters.addAll(Arrays.asList(elems));
        Composite composite = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite, 0);
        label.setText(Messages.SelectFBTypesWizardPage_Exporter);
        this.filters = new Combo(composite, 0);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.filters.setLayoutData((Object)data);
        for (IConfigurationElement exportFilter : this.exportFilters) {
            this.filters.add(exportFilter.getAttribute(NAME));
        }
        this.filters.addListener(13, event -> this.updatePageCompletion());
    }

    public IConfigurationElement getSelectedExportFilter() {
        return this.exportFilters.get(this.filters.getSelectionIndex());
    }

    protected boolean validateDestinationGroup() {
        if (this.getDirectory() == null || this.getDirectory().equals("") || !new File(this.getDirectory()).isDirectory()) {
            this.setErrorMessage(Messages.SelectFBTypesWizardPage_DestinationDirectoryNeedsToBeChosen);
            return false;
        }
        return super.validateDestinationGroup();
    }

    protected boolean validateOptionsGroup() {
        if (this.filters.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.SelectFBTypesWizardPage_ExportfilterNeedsToBeSelected);
            return false;
        }
        return super.validateOptionsGroup();
    }

    protected boolean validateSourceGroup() {
        if (this.getSelectedResources().isEmpty()) {
            this.setErrorMessage(Messages.SelectFBTypesWizardPage_NoTypeSelected);
            return false;
        }
        return super.validateSourceGroup();
    }

    public List getSelectedResources() {
        return super.getSelectedResources();
    }

    public boolean overwriteWithoutWarning() {
        return this.overwrite.getSelection();
    }

    public String getDirectory() {
        return this.destinationNameField.getText().trim();
    }

    public void setDirectory(String dir) {
        this.destinationNameField.setText(dir);
    }

    protected void restoreWidgetValues() {
        this.loadTargetDirctories();
        this.loadLastSelectedFilter();
    }

    private void loadTargetDirctories() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DIRECTORY_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDirectory(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.destinationNameField.add(directoryNames[i]);
                ++i;
            }
        }
    }

    private void loadLastSelectedFilter() {
        String currentFilterSelectionName;
        if (this.getDialogSettings() != null && (currentFilterSelectionName = this.getDialogSettings().get(STORE_CURRENT_FILTER_SELECTION_ID)) != null) {
            for (IConfigurationElement filter : this.exportFilters) {
                if (!filter.getAttribute(NAME).equals(currentFilterSelectionName)) continue;
                this.filters.select(this.exportFilters.indexOf(filter));
                break;
            }
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DIRECTORY_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDirectory());
            settings.put(STORE_DIRECTORY_NAMES_ID, directoryNames);
            this.getDialogSettings().put(STORE_CURRENT_FILTER_SELECTION_ID, this.getSelectedExportFilter().getAttribute(NAME));
        }
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(Messages.SelectFBTypesWizardPage_ExportDestination);
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        Button destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        destinationBrowseButton.setText(Messages.SelectFBTypesWizardPage_Browse);
        destinationBrowseButton.addListener(13, event -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 0x10002000);
            dialog.setMessage(Messages.SelectFBTypesWizardPage_SelectADirectoryToExportTo);
            dialog.setText(Messages.SelectFBTypesWizardPage_ExportToDirectory);
            dialog.setFilterPath(this.getDirectory());
            String selectedDirectoryName = dialog.open();
            if (selectedDirectoryName != null) {
                this.setErrorMessage(null);
                this.setDirectory(selectedDirectoryName);
            }
            this.updatePageCompletion();
        });
        destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        super.createOptionsGroupButtons(optionsGroup);
        this.addAvailableExportFilter(optionsGroup);
        this.overwrite = new Button((Composite)optionsGroup, 32);
        this.overwrite.setText(Messages.SelectFBTypesWizardPage_OverwriteWithoutWarning);
        GridData twoColumns = new GridData();
        twoColumns.grabExcessHorizontalSpace = true;
        twoColumns.grabExcessVerticalSpace = false;
        twoColumns.horizontalAlignment = 4;
        twoColumns.verticalAlignment = 128;
        this.overwrite.setLayoutData((Object)twoColumns);
    }

    public void handleEvent(Event event) {
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
    }
}

