/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.swt.graphics.Color;

public class ConnectorBorder
extends AbstractBorder {
    private static final int LR_MARGIN = 5;
    private static final int LR_ADAPTER_MARGIN = 11;
    private final IInterfaceElement editPartModelOject;
    private Color connectorColor;

    public ConnectorBorder(IInterfaceElement editPartModelOject) {
        this.editPartModelOject = editPartModelOject;
        this.updateColor();
    }

    public void updateColor() {
        this.connectorColor = this.isEvent() ? PreferenceGetter.getColor((String)"EventConnectionConnectorColor") : (this.isAdapter() ? PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor") : PreferenceGetter.getDataColor((String)this.editPartModelOject.getTypeName()));
    }

    protected static void createAdapterSymbolMiniFBrotated(Graphics graphics, Rectangle where, int width, boolean filled) {
        graphics.setLineWidth(1);
        graphics.setAntialias(1);
        PointList points = new PointList();
        int offest = 4;
        points.addPoint(width + where.x, where.y + offest);
        if (filled) {
            points.addPoint(width + where.x + 2, where.y + offest);
            points.addPoint(width + where.x + 2, where.y + offest + 2);
            points.addPoint(width + where.x + 4, where.y + offest + 2);
            points.addPoint(width + where.x + 4, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest + 8);
            points.addPoint(width + where.x + 4, where.y + offest + 8);
            points.addPoint(width + where.x + 4, where.y + offest + 6);
            points.addPoint(width + where.x + 2, where.y + offest + 6);
            points.addPoint(width + where.x + 2, where.y + offest + 8);
            points.addPoint(width + where.x, where.y + offest + 8);
            points.addPoint(width + where.x, where.y + offest);
            graphics.fillPolygon(points);
        } else {
            points.addPoint(width + where.x + 4, where.y + offest);
            points.addPoint(width + where.x + 4, where.y + offest + 2);
            points.addPoint(width + where.x + 6, where.y + offest + 2);
            points.addPoint(width + where.x + 6, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest);
            points.addPoint(width + where.x + 8, where.y + offest + 7);
            points.addPoint(width + where.x + 6, where.y + offest + 7);
            points.addPoint(width + where.x + 6, where.y + offest + 5);
            points.addPoint(width + where.x + 4, where.y + offest + 5);
            points.addPoint(width + where.x + 4, where.y + offest + 7);
            points.addPoint(width + where.x, where.y + offest + 7);
            points.addPoint(width + where.x, where.y + offest);
            graphics.drawPolygon(points);
        }
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setForegroundColor(this.connectorColor);
        graphics.setBackgroundColor(this.connectorColor);
        Rectangle where = ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        Rectangle r = null;
        if (this.isInput()) {
            if (this.isAdapter()) {
                ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, 0, false);
            } else {
                r = new Rectangle(where.x, where.y + where.height / 2 - 1, 4, 4);
                graphics.fillRectangle(r);
            }
        } else if (this.isAdapter()) {
            ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, where.width - 9, true);
        } else {
            r = new Rectangle(where.width + where.x - 4, where.y + where.height / 2 - 1, 4, 4);
            graphics.fillRectangle(r);
        }
    }

    public Insets getInsets(IFigure figure) {
        int lrMargin = this.isAdapter() ? 11 : 5;
        return new Insets(0, lrMargin, 0, lrMargin);
    }

    public boolean isInput() {
        return this.editPartModelOject.isIsInput();
    }

    public boolean isEvent() {
        return this.editPartModelOject instanceof Event;
    }

    public boolean isAdapter() {
        return this.editPartModelOject instanceof AdapterDeclaration;
    }
}

