/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedRoundedRectangle;
import org.eclipse.fordiac.ide.gef.draw2d.UnderlineAlphaLabel;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;

public class FBShape
extends Shape
implements IFontUpdateListener {
    private RoundedRectangle top;
    private AdvancedRoundedRectangle middle;
    private AdvancedRoundedRectangle bottom;
    private final Figure eventInputs = new Figure();
    private final Figure eventOutputs = new Figure();
    private final Figure dataInputs = new Figure();
    private final Figure sockets = new Figure();
    private final Figure dataOutputs = new Figure();
    private final Figure plugs = new Figure();
    private UnderlineAlphaLabel typeLabel;

    public FBShape(FBType fbType, ZoomManager zoomManager) {
        this.configureMainFigure();
        this.createFBFigureShape(fbType, zoomManager);
        this.setTypeLabelFont();
    }

    public Figure getEventInputs() {
        return this.eventInputs;
    }

    public Figure getEventOutputs() {
        return this.eventOutputs;
    }

    public Figure getDataInputs() {
        return this.dataInputs;
    }

    public Figure getSockets() {
        return this.sockets;
    }

    public Figure getDataOutputs() {
        return this.dataOutputs;
    }

    public Figure getPlugs() {
        return this.plugs;
    }

    public UnderlineAlphaLabel getTypeLabel() {
        return this.typeLabel;
    }

    public AdvancedRoundedRectangle getMiddle() {
        return this.middle;
    }

    public void setAlpha(int value) {
        super.setAlpha(value);
        this.bottom.setAlpha(value);
        this.top.setAlpha(value);
        this.getMiddle().setAlpha(value);
        if (this.getTypeLabel() != null) {
            this.getTypeLabel().setAlpha(value);
        }
    }

    @Override
    public void updateFonts() {
        this.setTypeLabelFont();
        this.invalidateTree();
        this.revalidate();
    }

    private void setTypeLabelFont() {
        this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
    }

    private void configureMainFigure() {
        this.setFillXOR(false);
        this.setOpaque(false);
        GridLayout mainLayout = new GridLayout(1, true);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = -1;
        this.setLayoutManager((LayoutManager)mainLayout);
    }

    private void createFBFigureShape(FBType fbType, ZoomManager zoomManager) {
        Color borderColor = FBShape.getBorderColor((LibraryElement)fbType);
        Figure fbFigureContainer = this.createFigureContainer();
        this.createFBTop(fbFigureContainer, 14, borderColor, zoomManager);
        this.configureFBMiddle(fbType, fbFigureContainer, borderColor, zoomManager);
        this.createFBBottom(fbFigureContainer, 14, borderColor, zoomManager);
    }

    private void createFBBottom(Figure fbFigureContainer, int cornerDim, Color borderColor, ZoomManager zoomManager) {
        this.bottom = new AdvancedRoundedRectangle(28, zoomManager, (Figure)this, false, borderColor);
        this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 4;
        bottomLayout.marginWidth = 0;
        bottomLayout.horizontalSpacing = 0;
        bottomLayout.verticalSpacing = 0;
        this.bottom.setLayoutManager((LayoutManager)bottomLayout);
        GridData bottomLayoutData = new GridData(1808);
        bottomLayoutData.verticalAlignment = 128;
        fbFigureContainer.add((IFigure)this.bottom);
        fbFigureContainer.setConstraint((IFigure)this.bottom, (Object)bottomLayoutData);
        this.setBottomIOs((IFigure)this.bottom);
    }

    private void configureFBMiddle(FBType fbType, Figure fbFigureContainer, Color borderColor, ZoomManager zoomManager) {
        Figure middleContainer = new Figure();
        BorderLayout borderLayout = new BorderLayout();
        middleContainer.setLayoutManager((LayoutManager)borderLayout);
        borderLayout.setHorizontalSpacing(10);
        middleContainer.setBorder((Border)new MarginBorder(0, 7, 0, 7));
        fbFigureContainer.add((IFigure)middleContainer);
        GridData middleLayouData = new GridData(768);
        fbFigureContainer.setConstraint((IFigure)middleContainer, (Object)middleLayouData);
        this.setupTypeNameAndVersion(fbType, middleContainer, borderColor, zoomManager);
    }

    private void createFBTop(Figure fbFigureContainer, int cornerDim, Color borderColor, ZoomManager zoomManager) {
        this.top = new AdvancedRoundedRectangle(25, zoomManager, (Figure)this, false, borderColor);
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 4;
        topLayout.marginWidth = 0;
        topLayout.horizontalSpacing = 0;
        topLayout.verticalSpacing = 0;
        this.top.setLayoutManager((LayoutManager)topLayout);
        fbFigureContainer.add((IFigure)this.top);
        GridData topLayoutData = new GridData(784);
        fbFigureContainer.setConstraint((IFigure)this.top, (Object)topLayoutData);
        this.setupTopIOs((IFigure)this.top);
    }

    private Figure createFigureContainer() {
        Figure fbFigureContainer = new Figure();
        this.add((IFigure)fbFigureContainer);
        this.setConstraint((IFigure)fbFigureContainer, new GridData(64));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = -1;
        fbFigureContainer.setLayoutManager((LayoutManager)gridLayout);
        return fbFigureContainer;
    }

    private void setupTopIOs(IFigure parent) {
        ToolbarLayout topInputsLayout = new ToolbarLayout(false);
        GridData topInputsLayoutData = new GridData(1808);
        this.eventInputs.setLayoutManager((LayoutManager)topInputsLayout);
        parent.add((IFigure)this.eventInputs);
        parent.setConstraint((IFigure)this.eventInputs, (Object)topInputsLayoutData);
        ToolbarLayout topOutputsLayout = new ToolbarLayout(false);
        GridData topOutputsLayoutData = new GridData(1680);
        topOutputsLayout.setMinorAlignment(2);
        this.eventOutputs.setLayoutManager((LayoutManager)topOutputsLayout);
        parent.add((IFigure)this.eventOutputs);
        parent.setConstraint((IFigure)this.eventOutputs, (Object)topOutputsLayoutData);
    }

    private void setBottomIOs(IFigure parent) {
        Figure bottomInputArea = new Figure();
        bottomInputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        GridData bottomInputsLayoutData = new GridData(1808);
        bottomInputsLayoutData.verticalAlignment = 128;
        parent.add((IFigure)bottomInputArea);
        parent.setConstraint((IFigure)bottomInputArea, (Object)bottomInputsLayoutData);
        this.dataInputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.dataInputs);
        this.sockets.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.sockets);
        Figure bottomOutputArea = new Figure();
        bottomOutputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)bottomOutputArea.getLayoutManager()).setMinorAlignment(2);
        GridData bottomOutputsLayoutData = new GridData(656);
        parent.add((IFigure)bottomOutputArea);
        parent.setConstraint((IFigure)bottomOutputArea, (Object)bottomOutputsLayoutData);
        this.dataOutputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.dataOutputs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.dataOutputs);
        this.plugs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.plugs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.plugs);
    }

    protected void setupTypeNameAndVersion(FBType type, Figure container, Color borderColor, ZoomManager zoomManager) {
        this.middle = new AdvancedRoundedRectangle(24, zoomManager, (Figure)this, false, borderColor);
        container.add((IFigure)this.middle, (Object)BorderLayout.CENTER);
        this.middle.setCornerDimensions(new Dimension());
        GridLayout middleLayout = new GridLayout(1, true);
        middleLayout.marginHeight = 2;
        middleLayout.verticalSpacing = 1;
        this.middle.setLayoutManager((LayoutManager)middleLayout);
        String typeName = type != null ? type.getName() : Messages.FBFigure_TYPE_NOT_SET;
        this.typeLabel = new UnderlineAlphaLabel(typeName != null ? typeName : FordiacMessages.ND);
        this.typeLabel.setTextAlignment(2);
        this.typeLabel.setOpaque(false);
        this.middle.add((IFigure)this.typeLabel);
        this.middle.setConstraint((IFigure)this.typeLabel, new GridData(768));
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        if (bg == null) {
            ((AdvancedRoundedRectangle)this.top).setBorderColor(this.getLocalForegroundColor());
            this.middle.setBorderColor(this.getLocalForegroundColor());
            this.bottom.setBorderColor(this.getLocalForegroundColor());
        } else {
            Color darkerColor = ColorHelper.darker((Color)bg);
            ((AdvancedRoundedRectangle)this.top).setBorderColor(darkerColor);
            this.middle.setBorderColor(darkerColor);
            this.bottom.setBorderColor(darkerColor);
        }
    }

    private static Color getBorderColor(LibraryElement type) {
        if (type instanceof AdapterFBType) {
            return PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor");
        }
        return ColorConstants.gray;
    }
}

