/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.fordiac.ide.gef.tools.ScrollingConnectionEndpointTracker;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;

public class FeedbackConnectionEndpointEditPolicy
extends ConnectionEndpointEditPolicy {
    private int selectedLineWidth = 5;
    private int unselectedLineWidth = 0;

    public FeedbackConnectionEndpointEditPolicy(int unselectedLineWidth, int selectedLineWidth) {
        this.selectedLineWidth = selectedLineWidth;
        this.unselectedLineWidth = unselectedLineWidth;
    }

    public FeedbackConnectionEndpointEditPolicy() {
    }

    protected void showSelection() {
        super.showSelection();
        this.getConnectionFigure().setLineWidth(this.selectedLineWidth);
    }

    protected PolylineConnection getConnectionFigure() {
        return (PolylineConnection)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected List createSelectionHandles() {
        ArrayList<ScrollingConnectionEndpointHandle> list = new ArrayList<ScrollingConnectionEndpointHandle>();
        list.add(new ScrollingConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2));
        list.add(new ScrollingConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3));
        return list;
    }

    protected void hideSelection() {
        super.hideSelection();
        this.getConnectionFigure().setLineWidth(this.unselectedLineWidth);
    }

    private static final class ScrollingConnectionEndpointHandle
    extends ConnectionEndpointHandle {
        private ScrollingConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
            super(owner, endPoint);
            this.setPreferredSize(9, 9);
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            ScrollingConnectionEndpointTracker tracker = new ScrollingConnectionEndpointTracker((ConnectionEditPart)this.getOwner());
            if (this.getEndPoint() == 2) {
                tracker.setCommandName("Reconnection source");
            } else {
                tracker.setCommandName("Reconnection target");
            }
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

