/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.gef.tools.FordiacConnectionDragCreationTool;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class ScrollingConnectionEndpointTracker
extends ConnectionEndpointTracker {
    private InlineConnectionDragCreationTool conCreationTool = null;

    public ScrollingConnectionEndpointTracker(ConnectionEditPart cep) {
        super(cep);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        if (this.isActive() && viewer instanceof AdvancedScrollingGraphicalViewer) {
            Point oldViewPort = ((AdvancedScrollingGraphicalViewer)viewer).getViewLocation();
            ((AdvancedScrollingGraphicalViewer)viewer).checkScrollPositionDuringDragBounded(me, new Point(26, 9));
            Dimension delta = oldViewPort.getDifference(((AdvancedScrollingGraphicalViewer)viewer).getViewLocation());
            this.setStartLocation(this.getStartLocation().getTranslated(delta));
        }
        if (this.conCreationTool != null) {
            this.getCurrentInput().setInput(me);
            this.conCreationTool.mouseDrag(me, viewer);
        } else if ((me.stateMask & SWT.MOD1) != 0) {
            this.startConnCreation();
        } else {
            super.mouseDrag(me, viewer);
        }
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        if (this.conCreationTool == null && keyEvent.keyCode == SWT.MOD1) {
            this.startConnCreation();
        } else {
            super.keyDown(keyEvent, viewer);
        }
    }

    private void startConnCreation() {
        EditPart target = this.getCommandName().equals("Reconnection source") ? this.getConnectionEditPart().getTarget() : this.getConnectionEditPart().getSource();
        this.conCreationTool = new InlineConnectionDragCreationTool(target, this.getDomain(), this.getCurrentViewer());
        this.updateTarget(this.getStartLocation());
    }

    private void updateTarget(Point p) {
        ReconnectRequest request = (ReconnectRequest)this.getTargetRequest();
        request.setLocation(p);
        EditPart target = this.getCommandName().equals("Reconnection source") ? this.getConnectionEditPart().getSource() : this.getConnectionEditPart().getTarget();
        request.setTargetEditPart(target);
        this.getConnectionEditPart().showSourceFeedback((Request)request);
        this.getConnectionEditPart().showTargetFeedback((Request)request);
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null && keyEvent.keyCode == SWT.MOD1) {
            this.conCreationTool.deactivate();
            this.conCreationTool = null;
            this.updateTarget(this.getLocation());
        }
        super.keyUp(keyEvent, viewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.mouseMove(me, viewer);
        } else {
            super.mouseMove(me, viewer);
        }
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.mouseUp(me, viewer);
            this.conCreationTool = null;
            this.handleFinished();
        } else {
            super.mouseUp(me, viewer);
        }
    }

    public void setEditDomain(EditDomain domain) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setEditDomain(domain);
        }
        super.setEditDomain(domain);
    }

    public void setViewer(EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setViewer(viewer);
        }
        super.setViewer(viewer);
    }

    public void viewerEntered(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.viewerEntered(mouseEvent, viewer);
        }
        super.viewerEntered(mouseEvent, viewer);
    }

    public void viewerExited(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.viewerExited(mouseEvent, viewer);
        }
        super.viewerExited(mouseEvent, viewer);
    }

    public void setProperties(Map properties) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setProperties(properties);
        }
        super.setProperties(properties);
    }

    public void commitDrag() {
        if (this.conCreationTool != null) {
            this.conCreationTool.commitDrag();
        }
        super.commitDrag();
    }

    private static final class InlineConnectionDragCreationTool
    extends FordiacConnectionDragCreationTool {
        private final EditPart originalSource;

        private InlineConnectionDragCreationTool(EditPart originalSource, EditDomain editDomain, EditPartViewer editPartViewer) {
            this.originalSource = originalSource;
            super.setEditDomain(editDomain);
            super.setViewer(editPartViewer);
            this.startDraggingFrom();
        }

        protected Command getCommand() {
            if (this.getTargetEditPart() instanceof ConnectionEditPart) {
                this.setTargetEditPart(this.originalSource);
                this.setConnectionSource(this.originalSource);
            }
            return super.getCommand();
        }

        private void startDraggingFrom() {
            super.activate();
            super.setTargetEditPart(null);
            super.handleButtonDown(1);
            super.handleDragStarted();
        }
    }
}

