/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizardPage;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewFBTypeWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewFBTypeWizardPage page1;
    private PaletteEntry entry;

    public NewFBTypeWizard() {
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void addPages() {
        this.page1 = this.createNewFBTypeWizardPage();
        this.addPage((IWizardPage)this.page1);
    }

    protected NewFBTypeWizardPage createNewFBTypeWizardPage() {
        return new NewFBTypeWizardPage(this.selection);
    }

    public boolean performFinish() {
        String typeName = this.page1.getFileName();
        File template = this.page1.getTemplate();
        if (!NewFBTypeWizard.checkTemplateAvailable(template.getAbsolutePath())) {
            return false;
        }
        IFile targetTypeFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.page1.getContainerFullPath() + File.separator + typeName));
        try {
            ImportUtils.copyFile((File)template, (IFile)targetTypeFile);
            return this.finishTypeCreation(targetTypeFile);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
    }

    private static boolean checkTemplateAvailable(String templatePath) {
        if (!new File(templatePath).exists()) {
            NewFBTypeWizard.templateNotAvailable(templatePath);
            return false;
        }
        return true;
    }

    private static void templateNotAvailable(String templatePath) {
        MessageBox mbx = new MessageBox(Display.getDefault().getActiveShell());
        mbx.setMessage(MessageFormat.format(Messages.NewFBTypeWizard_TemplateNotAvailable, templatePath));
        mbx.open();
    }

    private boolean finishTypeCreation(IFile targetTypeFile) {
        this.entry = FBTypeUtils.getPaletteEntryForFile(targetTypeFile);
        if (this.entry == null) {
            Palette palette = SystemManager.INSTANCE.getPalette(targetTypeFile.getProject());
            TypeLibrary.refreshPalette((Palette)palette);
            this.entry = FBTypeUtils.getPaletteEntryForFile(targetTypeFile);
        }
        LibraryElement type = this.entry.getType();
        type.setName(TypeLibrary.getTypeNameFromFile((IFile)targetTypeFile));
        TypeManagementPreferencesHelper.setupIdentification(type);
        TypeManagementPreferencesHelper.setupVersionInfo(type);
        AbstractTypeExporter.saveType((PaletteEntry)this.entry);
        this.entry.setType(type);
        if (this.page1.getOpenType()) {
            NewFBTypeWizard.openTypeEditor(this.entry);
        }
        return true;
    }

    private static void openTypeEditor(PaletteEntry entry) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
    }

    public PaletteEntry getPaletteEntry() {
        return this.entry;
    }
}

