/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewFBTypeWizardPage
extends WizardNewFileCreationPage {
    private static final Pattern NAME_PATTERN = Pattern.compile("Name=\"\\w+\"");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("Comment=\"[\\w\\s]+\"");
    private Button openTypeCheckbox;
    private int openTypeParentHeight = -1;
    private boolean openType = true;
    private TableViewer templateTableViewer;
    private TemplateInfo[] templateList;

    public NewFBTypeWizardPage(IStructuredSelection selection) {
        super(Messages.NewFBTypeWizardPage_NewTypePage, selection);
        this.setTitle(Messages.NewFBTypeWizardPage_CreateNewType);
        this.setDescription(Messages.NewFBTypeWizardPage_CreateNewTypeFromTemplateType);
        this.setAllowExistingResources(true);
        this.loadTypeTemplates();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        if (this.templateList == null || this.templateList.length == 0) {
            this.setErrorMessage(Messages.NewFBTypeWizardPage_NoTypeTemplatesFoundCheckTemplatesDirectory);
            return false;
        }
        if (super.getFileName().isEmpty()) {
            this.setErrorMessage(Messages.NewFBTypeWizardPage_EmptyTypenameIsNotValid);
            return false;
        }
        String errorMessage = IdentifierVerifyer.isValidIdentifierWithErrorMessage((String)super.getFileName());
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        if (this.getTemplate() == null) {
            this.setErrorMessage(Messages.NewFBTypeWizardPage_NoTypeSelected);
            return false;
        }
        this.setErrorMessage(null);
        return super.validatePage();
    }

    public File getTemplate() {
        if (this.templateTableViewer.getSelection() instanceof StructuredSelection) {
            Object selection = this.templateTableViewer.getStructuredSelection().getFirstElement();
            return selection instanceof TemplateInfo ? ((TemplateInfo)selection).templateFile : null;
        }
        return null;
    }

    protected String getNewFileLabel() {
        return String.valueOf(FordiacMessages.TypeName) + ":";
    }

    public String getFileName() {
        String[] splited;
        String retval = super.getFileName();
        if (this.getTemplate() != null && 2 == (splited = this.getTemplate().getName().split("\\.")).length) {
            retval = String.valueOf(retval) + "." + splited[1];
        }
        return retval;
    }

    public boolean getOpenType() {
        return this.openType;
    }

    protected void createAdvancedControls(Composite parent) {
        this.createTemplateTypeSelection(parent);
        super.createAdvancedControls(parent);
    }

    private void createTemplateTypeSelection(Composite parent) {
        Label fbTypeTypeLabel = new Label(parent, 0);
        fbTypeTypeLabel.setText(String.valueOf(FordiacMessages.SelectType) + ":");
        fbTypeTypeLabel.setFont(parent.getFont());
        this.templateTableViewer = TableWidgetFactory.createPropertyTableViewer((Composite)parent, (int)4);
        NewFBTypeWizardPage.configureTypeTableLayout(this.templateTableViewer.getTable());
        this.templateTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templateTableViewer.setLabelProvider((IBaseLabelProvider)new TypeTemplatesLabelProvider());
        this.templateTableViewer.setInput((Object)this.templateList);
        this.templateTableViewer.addSelectionChangedListener(ev -> this.handleEvent(null));
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.templateTableViewer.getControl().setLayoutData((Object)data);
    }

    private static void configureTypeTableLayout(Table table) {
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(FordiacMessages.Name);
        tc = new TableColumn(table, 16384);
        tc.setText(FordiacMessages.Description);
        TableLayout tabLayout = new TableLayout();
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 30));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 70));
        table.setLayout((Layout)tabLayout);
    }

    private void loadTypeTemplates() {
        Object[] files;
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        FileFilter ff = this.createTemplatesFileFilter();
        if (templateFolder.isDirectory() && (files = templateFolder.listFiles(ff)) != null) {
            Arrays.sort(files);
            this.templateList = new TemplateInfo[files.length];
            int i = 0;
            while (i < files.length) {
                this.templateList[i] = NewFBTypeWizardPage.createTemplateFileInfo((File)files[i]);
                ++i;
            }
        }
    }

    protected FileFilter createTemplatesFileFilter() {
        return pathname -> pathname.getName().toUpperCase().endsWith(".FBT") || pathname.getName().toUpperCase().endsWith(".ADP") || pathname.getName().toUpperCase().endsWith(".SUB");
    }

    private static TemplateInfo createTemplateFileInfo(File f) {
        String name = f.getName();
        String description = "";
        try {
            Scanner scanner = new Scanner(f);
            name = scanner.findWithinHorizon(NAME_PATTERN, 0);
            name = name.substring(6, name.length() - 1);
            scanner.close();
            scanner = new Scanner(f);
            description = scanner.findWithinHorizon(COMMENT_PATTERN, 0);
            description = description.substring(9, description.length() - 1);
        }
        catch (FileNotFoundException e) {
            Activator.getDefault().logError(Messages.NewFBTypeWizardPage_CouldNotFindTemplateFiles, e);
        }
        return new TemplateInfo(f, name, description);
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.openTypeCheckbox != null) {
            this.openTypeCheckbox.dispose();
            this.openTypeCheckbox = null;
            shell.setSize(shellSize.x, shellSize.y - this.openTypeParentHeight);
        } else {
            this.openTypeCheckbox = this.createOpenTypeGroup(composite);
            if (-1 == this.openTypeParentHeight) {
                Point groupSize = this.openTypeCheckbox.computeSize(-1, -1, true);
                this.openTypeParentHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.openTypeParentHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private Button createOpenTypeGroup(Composite parent) {
        this.openTypeCheckbox = new Button(parent, 32);
        this.openTypeCheckbox.setText(Messages.NewFBTypeWizardPage_OpenTypeForEditingWhenDone);
        this.openTypeCheckbox.setSelection(true);
        this.setPageComplete(this.validatePage());
        this.openTypeCheckbox.addListener(13, ev -> {
            boolean bl = this.openType = this.openTypeCheckbox.getSelection();
        });
        return this.openTypeCheckbox;
    }

    private static class TemplateInfo {
        private File templateFile;
        private String templateName;
        private String templateDescription;

        public TemplateInfo(File templateFile, String templateName, String templateDescription) {
            this.templateFile = templateFile;
            this.templateName = templateName;
            this.templateDescription = templateDescription;
        }
    }

    private static class TypeTemplatesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TypeTemplatesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TemplateInfo) {
                switch (columnIndex) {
                    case 0: {
                        return ((TemplateInfo)element).templateName;
                    }
                    case 1: {
                        return ((TemplateInfo)element).templateDescription;
                    }
                }
            }
            return "";
        }
    }
}

