/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.util.Utils;

public class DelayedFiles {
    private List<FileObject> storage = new ArrayList<FileObject>(2);

    public Path write(Path path, CharSequence data) {
        this.storage.add(new FileObject(path, data));
        return path;
    }

    public Iterable<StoredFiles> write(boolean forceOverwrite) throws IOException {
        ArrayList<StoredFiles> ret = new ArrayList<StoredFiles>(this.storage.size());
        for (FileObject fo : this.storage) {
            File o = null;
            File f = fo.getPath().toFile();
            if (!forceOverwrite && f.exists()) {
                o = Utils.createBakFile((File)f);
            }
            Files.write(fo.getPath(), fo.getData(), StandardCharsets.UTF_8, new OpenOption[0]);
            ret.add(new StoredFiles(o, f));
        }
        this.clear();
        return ret;
    }

    public boolean exist() {
        for (FileObject fo : this.storage) {
            if (!fo.getPath().toFile().exists()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.storage.clear();
    }

    private static final class FileObject {
        private final Path path;
        private final Iterable<? extends CharSequence> data;

        public FileObject(Path path, CharSequence data) {
            this.path = path;
            this.data = Collections.singleton(data);
        }

        public Path getPath() {
            return this.path;
        }

        public Iterable<CharSequence> getData() {
            return this.data;
        }
    }

    public static final class StoredFiles {
        private final File oldFile;
        private final File newFile;

        public StoredFiles(File oldFile, File newFile) {
            this.oldFile = oldFile;
            this.newFile = newFile;
        }

        public File getOldFile() {
            return this.oldFile;
        }

        public File getNewFile() {
            return this.newFile;
        }
    }
}

