/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class RESImporter
extends TypeImporter {
    private final Palette palette;

    public RESImporter(Palette palette) {
        this.palette = palette;
    }

    @Override
    protected ResourceType getType() {
        return (ResourceType)super.getType();
    }

    @Override
    protected LibraryElement createType() {
        return LibraryElementFactory.eINSTANCE.createResourceType();
    }

    @Override
    protected String getStartElementName() {
        return "ResourceType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getTypeChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getType());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getType());
                    break;
                }
                case "CompilerInfo": {
                    this.parseCompilerInfo(this.getType());
                    break;
                }
                case "VarDeclaration": {
                    VarDeclaration v = this.parseVarDeclaration();
                    v.setIsInput(true);
                    this.getType().getVarDeclaration().add((Object)v);
                    break;
                }
                case "FBNetwork": {
                    this.getType().setFBNetwork(new ResDevFBNetworkImporter(this.palette, this.getType().getVarDeclaration(), this.getReader()).parseFBNetwork("FBNetwork"));
                    break;
                }
                default: {
                    return false;
                }
                case "FBTypeName": 
            }
            return true;
        };
    }
}

