/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.ElementaryType;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DataTypeLibrary {
    private Map<String, DataType> typeMap = new HashMap<String, DataType>();
    private static DataTypeLibrary instance;

    private DataTypeLibrary() {
        this.initElementaryTypes();
    }

    public static DataTypeLibrary getInstance() {
        if (instance == null) {
            instance = new DataTypeLibrary();
        }
        return instance;
    }

    private void initElementaryTypes() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, DataType>();
        }
        BaseType1.VALUES.forEach(baseType -> {
            ElementaryType type = DataFactory.eINSTANCE.createElementaryType();
            type.setName(baseType.getLiteral());
            this.typeMap.put(baseType.getLiteral(), type);
        });
    }

    public Collection<DataType> getDataTypes() {
        return this.typeMap.values();
    }

    public Collection<DataType> getDataTypesSorted() {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(this.getDataTypes());
        Collections.sort(dataTypes, NamedElementComparator.INSTANCE);
        return dataTypes;
    }

    public DataType getType(String name) {
        if (name == null) {
            return this.typeMap.get("ANY");
        }
        DataType value = this.typeMap.get(name.toUpperCase());
        if (value != null) {
            return value;
        }
        ElementaryType type = DataFactory.eINSTANCE.createElementaryType();
        type.setName(name);
        this.typeMap.put(name, type);
        return type;
    }

    public static void loadReferencedDataTypes(File srcFile, Shell shell) throws TypeImportException {
        List<String> referencedDataTypes = DataTypeLibrary.getReferencedDataTypes(srcFile);
        for (String dataType : referencedDataTypes) {
            DataType type = DataTypeLibrary.getInstance().getType(dataType);
            if (type != null) continue;
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            FileDialog fd = new FileDialog(shell);
            String msg = MessageFormat.format(Messages.TypeLibrary_ImportDataTypeFileDialogTitle, dataType);
            fd.setText(msg);
            fd.setFilterExtensions(new String[]{"*.dtp"});
            String typeFile = fd.open();
            if (typeFile != null) continue;
            throw new TypeImportException(Messages.TypeLibrary_ERROR_ReferencedDataTypeNotFound);
        }
    }

    private static List<String> getReferencedDataTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("VarDeclaration")) {
                    String dataType = "";
                    dataType = n.getAttributes().getNamedItem("Type").getNodeValue();
                    references.add(dataType);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return references;
    }
}

