/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.actions.CopyEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.CutEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.DeleteFBNetworkAction;
import org.eclipse.fordiac.ide.application.actions.FBNetworkSelectAllAction;
import org.eclipse.fordiac.ide.application.actions.PasteEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.UnmapAction;
import org.eclipse.fordiac.ide.application.actions.UnmapAllAction;
import org.eclipse.fordiac.ide.application.actions.UpdateFBTypeAction;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editors.FBTypePaletteViewerProvider;
import org.eclipse.fordiac.ide.application.editparts.ElementEditPartFactory;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.utilities.ApplicationEditorTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class FBNetworkEditor
extends DiagramEditorWithFlyoutPalette
implements ISystemEditor {
    private static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("FBNetworkPalette.Location", "FBNetworkPalette.Size", "FBNetworkPalette.State");
    private FBNetwork model;

    protected void setModel(FBNetwork model) {
        this.model = model;
    }

    public CommandStack getFBEditorCommandStack() {
        return this.getCommandStack();
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new FBNetworkRootEditPart(this.getModel(), this.getPalette(), this.getSite(), this.getActionRegistry());
    }

    public FBNetwork getModel() {
        return this.model;
    }

    protected EditPartFactory getEditPartFactory() {
        return new ElementEditPartFactory((GraphicalEditor)this, this.getZoomManger());
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FBNetworkContextMenuProvider(this, this.getActionRegistry(), zoomManager, this.getPalette());
    }

    protected Palette getPalette() {
        return this.getSystem().getPalette();
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new ApplicationEditorTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.getSystem());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalControl().addListener(26, this::handleActivationChanged);
        this.getGraphicalControl().addListener(27, this::handleActivationChanged);
    }

    public AutomationSystem getSystem() {
        return this.getModel().getAutomationSystem();
    }

    public void doSave(IProgressMonitor monitor) {
        SystemManager.INSTANCE.saveSystem(this.getSystem());
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new UnmapAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UnmapAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyEditPartsAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CutEditPartsAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteEditPartsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UpdateFBTypeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        super.createActions();
        action = registry.getAction((Object)ActionFactory.SELECT_ALL.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new FBNetworkSelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = registry.getAction((Object)ActionFactory.DELETE.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new DeleteFBNetworkAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void dispose() {
        super.dispose();
        this.getEditDomain().setPaletteViewer(null);
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new FBTypePaletteViewerProvider(this.getSystem().getProject(), (EditDomain)this.getEditDomain(), this.getPalletNavigatorID());
    }

    protected String getPalletNavigatorID() {
        return "org.eclipse.fordiac.ide.fbpaletteviewer";
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return PALETTE_PREFERENCES;
    }

    public void selectElement(Object element) {
        EditPart editPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(element);
        if (editPart != null) {
            this.getGraphicalViewer().flush();
            this.getGraphicalViewer().select(editPart);
            this.getGraphicalViewer().reveal(editPart);
        }
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == FBNetwork.class) {
            return this.getModel();
        }
        return super.getAdapter(adapter);
    }

    private void handleActivationChanged(Event event) {
        IAction copy = null;
        IAction cut = null;
        IAction paste = null;
        if (event.type == 26) {
            copy = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
            cut = this.getActionRegistry().getAction((Object)ActionFactory.CUT.getId());
            paste = this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId());
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()) != copy) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()) != cut) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), cut);
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()) != paste) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), paste);
        }
        this.getEditorSite().getActionBars().updateActionBars();
    }

    protected AdvancedPanningSelectionTool createDefaultTool() {
        return new AdvancedPanningSelectionTool(){
            static final int LEFT_MOUSE = 1;
            static final double TYPE_DISTANCE = 10.0;
            private Point lastLeftClick = new Point(0, 0);

            public void mouseUp(MouseEvent me, EditPartViewer viewer) {
                if (1 == me.button) {
                    this.lastLeftClick = this.getLocation();
                }
                super.mouseUp(me, viewer);
            }

            public void keyDown(KeyEvent evt, EditPartViewer viewer) {
                EditPart editPart;
                if (Character.isLetterOrDigit(evt.character) && 10.0 > this.getLocation().getDistance(this.lastLeftClick) && (editPart = this.getCurrentViewer().findObjectAt(this.getLocation())) != null) {
                    SelectionRequest request = new SelectionRequest();
                    request.setLocation(this.lastLeftClick);
                    request.setType((Object)"open");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(String.valueOf(evt.character), String.valueOf(evt.character));
                    request.setExtendedData(map);
                    editPart.performRequest((Request)request);
                    return;
                }
                super.keyDown(evt, viewer);
            }
        };
    }
}

