/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.application.editparts.SubAppInternalInterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FollowConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FBNetworkEditor editor = (FBNetworkEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        List<IInterfaceElement> opposites = FollowConnectionHandler.getConnectionOposites(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (!opposites.isEmpty()) {
            if (opposites.size() == 1) {
                editor.selectElement(opposites.get(0));
            } else {
                FollowConnectionHandler.showOppositeSelectionDialog(opposites, event, editor);
            }
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(!FollowConnectionHandler.getConnectionOposites(selection).isEmpty());
    }

    private static List<IInterfaceElement> getConnectionOposites(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof InterfaceEditPartForFBNetwork) {
            InterfaceEditPartForFBNetwork editPart = (InterfaceEditPartForFBNetwork)((Object)structuredSelection.getFirstElement());
            EList<Connection> connList = FollowConnectionHandler.getConnectionList(editPart);
            return connList.stream().map(con -> con.getSource().equals(editPart.getModel()) ? con.getDestination() : con.getSource()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static EList<Connection> getConnectionList(InterfaceEditPartForFBNetwork editPart) {
        if (editPart instanceof SubAppInternalInterfaceEditPart) {
            return editPart.getModel().isIsInput() ? editPart.getModel().getOutputConnections() : editPart.getModel().getInputConnections();
        }
        return editPart.isInput() ? editPart.getModel().getInputConnections() : editPart.getModel().getOutputConnections();
    }

    private static void showOppositeSelectionDialog(List<IInterfaceElement> opposites, ExecutionEvent event, FBNetworkEditor editor) throws ExecutionException {
        OppositeSelectionDialog dialog = new OppositeSelectionDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), opposites, editor);
        dialog.open();
    }

    private static class OppositeSelectionDialog
    extends PopupDialog {
        private final List<IInterfaceElement> opposites;
        private final FBNetworkEditor editor;

        public OppositeSelectionDialog(Shell parent, List<IInterfaceElement> opposites, FBNetworkEditor editor) {
            super(parent, 16, true, false, false, false, false, Messages.FBPaletteViewer_SelectConnectionEnd, null);
            this.opposites = opposites;
            this.editor = editor;
        }

        protected void adjustBounds() {
            super.adjustBounds();
            Point pt = this.getShell().getDisplay().getCursorLocation();
            Rectangle rect = this.getShell().getBounds();
            rect.x = pt.x;
            rect.y = pt.y;
            this.getShell().setBounds(rect);
        }

        protected Control createDialogArea(Composite parent) {
            final Composite dialogArea = (Composite)super.createDialogArea(parent);
            ListViewer listViewer = new ListViewer(dialogArea, 4);
            listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IInterfaceElement) {
                        IInterfaceElement iElem = (IInterfaceElement)element;
                        String retVal = "";
                        if (iElem.getFBNetworkElement() != null) {
                            retVal = String.valueOf(iElem.getFBNetworkElement().getName()) + ".";
                        }
                        return String.valueOf(retVal) + iElem.getName();
                    }
                    return super.getText(element);
                }
            });
            listViewer.setInput((Object)this.opposites.toArray());
            listViewer.addSelectionChangedListener(event -> this.editor.selectElement(event.getStructuredSelection().getFirstElement()));
            listViewer.getControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        dialogArea.getShell().close();
                    }
                }
            });
            return dialogArea;
        }
    }
}

