/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizard;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveAsSubappTypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FBNetworkEditor editor = (FBNetworkEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            EditPart ep = (EditPart)selected;
            SubApp subApp = (SubApp)ep.getModel();
            if (!SaveAsSubappTypeHandler.checkContainedSubApps(subApp)) {
                SaveAsSubappTypeHandler.showInformationDialog(editor.getSite().getShell());
                continue;
            }
            SaveAsSubappTypeHandler.invokeSaveWizard(subApp, editor);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(SaveAsSubappTypeHandler.calculateEnabled(selection));
    }

    private static boolean calculateEnabled(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                if (selected instanceof EditPart) {
                    if (((EditPart)selected).getModel() instanceof SubApp) {
                        if (((SubApp)((EditPart)selected).getModel()).getPaletteEntry() == null) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static void showInformationDialog(Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.SaveAsSubApplicationTypeAction_UntypedSubappError, (String)Messages.SaveAsSubApplicationTypeAction_UntypedSubappErrorDescription);
    }

    private static void invokeSaveWizard(SubApp subApp, FBNetworkEditor editor) {
        SaveAsSubappWizard wizard = new SaveAsSubappWizard(subApp);
        WizardDialog dialog = new WizardDialog(editor.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private static boolean checkContainedSubApps(SubApp subApp) {
        for (FBNetworkElement element : subApp.getSubAppNetwork().getNetworkElements()) {
            if (!(element instanceof SubApp) || element.getPaletteEntry() != null) continue;
            return false;
        }
        return true;
    }
}

