/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateFBTypeHandler
extends AbstractHandler {
    private final List<FBNetworkElement> selectedNetworkElements = new ArrayList<FBNetworkElement>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand cmd = new CompoundCommand();
        FBNetworkEditor fbEditor = (FBNetworkEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CommandStack stack = fbEditor.getCommandStack();
        for (FBNetworkElement element : this.selectedNetworkElements) {
            UpdateFBTypeCommand updateFBTypeCmd = new UpdateFBTypeCommand(element, null);
            if (!updateFBTypeCmd.canExecute()) continue;
            cmd.add((Command)updateFBTypeCmd);
        }
        if (stack != null) {
            stack.execute((Command)cmd);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        this.updateSelection(evaluationContext);
        this.setBaseEnabled(!this.selectedNetworkElements.isEmpty());
    }

    protected void updateSelection(Object evaluationContext) {
        this.selectedNetworkElements.clear();
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof EditPart) {
                    element = ((EditPart)element).getModel();
                }
                if (!(element instanceof FBNetworkElement) || ((FBNetworkElement)element).getType() == null) continue;
                this.selectedNetworkElements.add((FBNetworkElement)element);
            }
        }
    }
}

