/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Connection;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.DeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.QueryResponseHandler;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.export.forte_lua.ForteLuaExportFilter;
import org.eclipse.fordiac.ide.model.Annotations;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceCreateCommand;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DynamicTypeLoadDeploymentExecutor
extends DeploymentExecutor {
    private static final String CREATE_FB_TYPE = "<Request ID=\"{0}\" Action=\"CREATE\"><FBType Name=\"{1}\">{2}</FBType></Request>";
    private static final String CREATE_ADAPTER_TYPE = "<Request ID=\"{0}\" Action=\"CREATE\"><AdapterType Name=\"{1}\">{2}</AdapterType></Request>";
    private static final String QUERY_FB_TYPES = "<Request ID=\"{0}\" Action=\"QUERY\"><FBType Name=\"*\" /></Request>";
    private static final String QUERY_FB_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><FBType Name=\"{1}\" /></Request>";
    private static final String QUERY_ADAPTER_TYPES = "<Request ID=\"{0}\" Action=\"QUERY\"><AdapterType Name=\"*\" /></Request>";
    private static final String QUERY_ADAPTER_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><AdapterType Name=\"{1}\" /></Request>";
    private static final String QUERY_CONNECTIONS = "<Request ID=\"{0}\" Action=\"QUERY\"><Connection Source=\"{1}\" Destination=\"{2}\"/></Request>";
    private static final String QUERY_PARAMETER = "<Request ID=\"{0}\" Action=\"READ\"><Connection Source=\"{1}\" Destination=\"*\" /></Request>";
    private static final Logger logger = Logger.getLogger(DynamicTypeLoadDeploymentExecutor.class);
    private ResponseMapping respMapping = new ResponseMapping();

    public DynamicTypeLoadDeploymentExecutor(Device dev, IDeviceManagementCommunicationHandler overrideHandler) {
        super(dev, overrideHandler);
    }

    public void connect() throws DeploymentException {
        super.connect();
        this.queryFBTypes();
        this.queryAdapterTypes();
    }

    @Override
    public void createFBInstance(FBDeploymentData fbData, Resource res) throws DeploymentException {
        Map<String, AdapterType> adapters = DynamicTypeLoadDeploymentExecutor.getAdapterTypes(fbData.getFb().getType().getInterfaceList());
        if (!adapters.isEmpty()) {
            this.createAdapterTypes(adapters);
        }
        this.checkCreateFBType(fbData.getFb().getType());
        super.createFBInstance(fbData, res);
    }

    private static Map<String, AdapterType> getAdapterTypes(InterfaceList interfaceList) {
        HashMap<String, AdapterType> list = new HashMap<String, AdapterType>();
        interfaceList.getPlugs().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        interfaceList.getSockets().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        return list;
    }

    private void checkCreateFBType(FBType fbType) {
        if (!this.getTypes().contains(fbType.getName())) {
            try {
                this.createFBType(fbType);
            }
            catch (DeploymentException deploymentException) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, fbType.getName()));
            }
        }
    }

    public void createFBType(FBType fbType) throws DeploymentException {
        DynamicTypeLoadDeploymentExecutor.setAttribute(this.getDevice(), "FBType", this.getTypes());
        if (fbType instanceof BasicFBType || fbType instanceof CompositeFBType) {
            if (fbType instanceof CompositeFBType) {
                this.createFBTypesOfCFB(fbType);
            }
            String request = this.createLuaXmlRequestMessage(fbType);
            this.sendCreateFBTypeREQ(fbType, request);
        }
    }

    private void sendCreateFBTypeREQ(FBType fbType, String request) throws DeploymentException {
        try {
            String result = this.sendREQ("", request);
            if (result.contains("Reason")) {
                throw new DeploymentException(MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_LUAScriptForFBTypeNotExecuted, fbType.getName()));
            }
            this.getTypes().add(fbType.getName());
        }
        catch (IOException iOException) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, "LUA script"));
        }
    }

    private void createFBTypesOfCFB(FBType fbType) throws DeploymentException {
        for (FBNetworkElement netelem : ((CompositeFBType)fbType).getFBNetwork().getNetworkElements()) {
            if (this.getTypes().contains(netelem.getTypeName())) continue;
            Map<String, AdapterType> adapters = DynamicTypeLoadDeploymentExecutor.getAdapterTypes(netelem.getInterface());
            if (!adapters.isEmpty()) {
                this.createAdapterTypes(adapters);
            }
            this.createFBType(netelem.getType());
        }
    }

    private String createLuaXmlRequestMessage(FBType fbType) {
        ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
        String escapedLuaScript = DynamicTypeLoadDeploymentExecutor.escapeXmlCharacters(luaFilter.createLUA((LibraryElement)fbType));
        return MessageFormat.format(CREATE_FB_TYPE, this.getNextId(), fbType.getName(), escapedLuaScript);
    }

    private static String escapeXmlCharacters(String luaScript) {
        luaScript = luaScript.replace("&", "&amp;");
        luaScript = luaScript.replace("<", "&lt;");
        luaScript = luaScript.replace(">", "&gt;");
        luaScript = luaScript.replace("\"", "&quot;");
        return luaScript.replace("'", "&apos;");
    }

    private static boolean isAttribute(Device device, String fbTypeName, String attributeType) {
        if (device.getAttribute(attributeType) != null) {
            String[] stringArray = device.getAttributeValue(attributeType).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (fbTypeName.equals(s.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void setAttribute(Device device, String string, Set<String> hashSet) {
        Display.getDefault().asyncExec(() -> device.setAttribute(string, "STRING", String.join((CharSequence)", ", hashSet), "created during deployment"));
    }

    public void createAdapterType(String adapterKey, Map<String, AdapterType> adapters) throws DeploymentException {
        DynamicTypeLoadDeploymentExecutor.setAttribute(this.getDevice(), "AdapterType", this.getAdapterTypes());
        if (!this.getAdapterTypes().contains(adapterKey) || !DynamicTypeLoadDeploymentExecutor.isAttribute(this.getDevice(), adapterKey, "AdapterType")) {
            ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
            String luaSkript = luaFilter.createLUA((LibraryElement)adapters.get(adapterKey));
            String request = MessageFormat.format(CREATE_ADAPTER_TYPE, this.getNextId(), adapterKey, luaSkript);
            this.sendCreateAdapterTypeREQ(adapterKey, request);
        }
    }

    private void sendCreateAdapterTypeREQ(String adapterKey, String request) throws DeploymentException {
        try {
            String result = this.sendREQ("", request);
            if (result.contains("Reason")) {
                throw new DeploymentException(MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_LUAScriptForAdapterTypeNotExecuted, adapterKey));
            }
            this.getAdapterTypes().add(adapterKey);
        }
        catch (IOException iOException) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, "Adapter"));
        }
    }

    public void queryResourcesWithNetwork(Device dev) {
        try {
            for (org.eclipse.fordiac.ide.deployment.devResponse.Resource resource : this.queryResources()) {
                ResourceCreateCommand cmd = new ResourceCreateCommand(DynamicTypeLoadDeploymentExecutor.getResourceType(dev, resource.getType()), dev, false);
                cmd.execute();
                cmd.getResource().setName(resource.getName());
                dev.getResource().add((Object)cmd.getResource());
                this.queryFBNetwork(cmd.getResource());
                this.queryConnections(cmd.getResource());
                this.queryParameters(cmd.getResource());
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Resources"));
        }
    }

    private void queryParameters(Resource res) {
        for (FBNetworkElement fb : res.getFBNetwork().getNetworkElements()) {
            for (VarDeclaration inVar : fb.getInterface().getInputVars()) {
                if (!inVar.getInputConnections().isEmpty()) continue;
                this.queryParameter(res, fb, inVar);
            }
        }
    }

    private void queryParameter(Resource res, FBNetworkElement fb, VarDeclaration inVar) {
        String request = MessageFormat.format(QUERY_PARAMETER, this.getNextId(), String.valueOf(fb.getName()) + "." + inVar.getName());
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                DynamicTypeLoadDeploymentExecutor.createParameter(res, inVar, this.parseResponse(result));
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Parameter"));
        }
    }

    private static void createParameter(Resource res, VarDeclaration inVar, Response response) {
        if (response.getConnection() != null) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(response.getConnection().getDestination());
            inVar.setValue(value);
        }
    }

    private void queryConnections(Resource res) {
        String request = MessageFormat.format(QUERY_CONNECTIONS, this.getNextId(), "*", "*");
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                DynamicTypeLoadDeploymentExecutor.createConnections(res, this.parseResponse(result));
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Connections"));
        }
    }

    private static void createConnections(Resource res, Response response) {
        if (response.getEndpointlist() != null) {
            for (Connection connection : response.getEndpointlist().getConnection()) {
                String[] src = connection.getSource().split("\\.");
                FB srcFB = Annotations.getFBNamed((FBNetwork)res.getFBNetwork(), (String)src[0]);
                IInterfaceElement srcIE = Annotations.getInterfaceElement((FBNetworkElement)srcFB, (String)src[src.length - 1]);
                String[] dst = connection.getDestination().split("\\.");
                FB dstFB = Annotations.getFBNamed((FBNetwork)res.getFBNetwork(), (String)dst[0]);
                IInterfaceElement dstIE = Annotations.getInterfaceElement((FBNetworkElement)dstFB, (String)dst[dst.length - 1]);
                DynamicTypeLoadDeploymentExecutor.createConnectionCommand(res.getFBNetwork(), srcIE, dstIE);
            }
        }
    }

    private static void createConnectionCommand(FBNetwork fbNet, IInterfaceElement srcIE, IInterfaceElement dstIE) {
        EventConnectionCreateCommand cmd = null;
        if (srcIE instanceof Event) {
            cmd = new EventConnectionCreateCommand(fbNet);
        } else if (srcIE instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(fbNet);
        } else if (srcIE instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(fbNet);
        }
        if (cmd != null) {
            cmd.setSource(srcIE);
            cmd.setDestination(dstIE);
            if (cmd.canExecute()) {
                cmd.execute();
            }
        }
    }

    private void queryFBNetwork(Resource res) {
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"QUERY\"><FB Name=\"*\" Type=\"*\"/></Request>", this.getNextId());
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                InputSource source = new InputSource(new StringReader(result));
                XMLResourceImpl xmlResource = new XMLResourceImpl();
                xmlResource.load(source, this.respMapping.getLoadOptions());
                this.createFBNetwork(res, (XMLResource)xmlResource);
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Networks"));
        }
    }

    private void createFBNetwork(Resource res, XMLResource xmlResource) {
        for (EObject object : xmlResource.getContents()) {
            if (!(object instanceof Response)) continue;
            this.createNotExistingAdapterTypes(res);
            this.addFBNetworkElements(res, (Response)object);
        }
    }

    private void createNotExistingAdapterTypes(Resource res) {
        for (String entryName : this.getAdapterTypes()) {
            if (res.getDevice().getAutomationSystem().getPalette().getAdapterTypeEntry(entryName) != null) continue;
            this.addTypeToTypelib(res, entryName, "adp", QUERY_ADAPTER_TYPE);
        }
    }

    private void addFBNetworkElements(Resource res, Response object) {
        int i = 0;
        for (org.eclipse.fordiac.ide.deployment.devResponse.FB fbresult : object.getFblist().getFbs()) {
            FBCreateCommand fbcmd;
            if ("E_RESTART".equals(fbresult.getType())) continue;
            FBTypePaletteEntry entry = res.getDevice().getAutomationSystem().getPalette().getFBTypeEntry(fbresult.getType());
            if (entry == null) {
                this.addTypeToTypelib(res, fbresult.getType(), "fbt", QUERY_FB_TYPE);
                entry = res.getDevice().getAutomationSystem().getPalette().getFBTypeEntry(fbresult.getType());
            }
            if ((fbcmd = new FBCreateCommand(entry, res.getFBNetwork(), 100 * i, 10)).canExecute()) {
                fbcmd.execute();
                fbcmd.getFB().setName(fbresult.getName());
            }
            ++i;
        }
    }

    private void addTypeToTypelib(Resource res, String typeName, String extension, String messageType) {
        String request = MessageFormat.format(messageType, this.getNextId(), typeName);
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                result = result.replaceFirst("<Response ID=\"[0-9]+\">\n", "");
                if (!(result = result.replaceFirst("</Response>", "")).contains("Reason=\"UNSUPPORTED_TYPE\"") && !result.contains("Reason=\"UNSUPPORTED_CMD\"")) {
                    AutomationSystem system = res.getDevice().getAutomationSystem();
                    Path path = Paths.get(system.getProject().getLocation() + File.separator + "generated" + File.separator + typeName + "." + extension, new String[0]);
                    File file = new File(path.toString());
                    file.getParentFile().mkdirs();
                    Files.write(path, result.getBytes(), StandardOpenOption.CREATE);
                    Palette palette = system.getPalette();
                    TypeLibrary.refreshPalette((Palette)palette);
                }
            }
        }
        catch (Exception exception) {
            if (messageType.equals(QUERY_ADAPTER_TYPE)) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Adapter Type"));
            }
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "FB Type"));
        }
    }

    private static ResourceTypeEntry getResourceType(Device device, String resTypeName) {
        return device.getPaletteEntry().getPalette().getResourceTypeEntry(resTypeName);
    }

    private void queryFBTypes() {
        String request = MessageFormat.format(QUERY_FB_TYPES, this.getNextId());
        try {
            QueryResponseHandler queryResp = this.sendQUERY("", request);
            this.setTypes(queryResp.getQueryResult());
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "FB Types"));
        }
    }

    private void queryAdapterTypes() {
        String request = MessageFormat.format(QUERY_ADAPTER_TYPES, this.getNextId());
        try {
            QueryResponseHandler queryResp = this.sendQUERY("", request);
            this.setAdapterTypes(queryResp.getQueryResult());
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Adapter Types"));
        }
    }

    private void createAdapterTypes(Map<String, AdapterType> adapters) {
        adapters.keySet().forEach(e -> {
            try {
                this.createAdapterType((String)e, adapters);
            }
            catch (DeploymentException deploymentException) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, e));
            }
        });
    }

    private QueryResponseHandler sendQUERY(String destination, String request) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        QueryResponseHandler handler = new QueryResponseHandler();
        String response = this.sendREQ(destination, request);
        saxParser.parse(new InputSource(new StringReader(response)), (DefaultHandler)handler);
        return handler;
    }
}

