/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.properties;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.properties.AdapterInterfaceElementSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInitialValueCommand;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataInterfaceElementSection
extends AdapterInterfaceElementSection {
    private Text arraySizeText;
    private Text initValueText;
    private TableViewer withEventsViewer;
    private Group eventComposite;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createDataSection(this.getLeftComposite());
        this.createEventSection(this.getRightComposite());
    }

    private void createDataSection(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, String.valueOf(FordiacMessages.ArraySize) + ":");
        this.arraySizeText = this.createGroupText(parent, true);
        this.arraySizeText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeArraySizeCommand((VarDeclaration)this.type, this.arraySizeText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(parent, String.valueOf(FordiacMessages.InitialValue) + ":");
        this.initValueText = this.createGroupText(parent, true);
        this.initValueText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeInitialValueCommand((VarDeclaration)this.type, this.initValueText.getText()));
            this.addContentAdapter();
        });
    }

    private void createEventSection(Composite parent) {
        this.eventComposite = this.getWidgetFactory().createGroup(parent, FordiacMessages.With);
        this.eventComposite.setLayout((Layout)new GridLayout(1, false));
        this.eventComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.withEventsViewer = TableWidgetFactory.createPropertyTableViewer((Composite)this.eventComposite, (int)32);
        this.withEventsViewer.setContentProvider((IContentProvider)new EventContentProvider());
        this.withEventsViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        Table tableWith = this.withEventsViewer.getTable();
        DataInterfaceElementSection.configureTableLayout(tableWith);
        tableWith.addListener(13, event -> {
            if (event.detail == 32) {
                TableItem checkedItem = (TableItem)event.item;
                Event e = (Event)checkedItem.getData();
                With with = e.getWith().stream().filter(w -> w.getVariables().equals(this.getType())).findFirst().orElse(null);
                if (checkedItem.getChecked()) {
                    if (with == null) {
                        this.executeCommand((Command)new WithCreateCommand(e, this.getType()));
                    }
                } else if (with != null) {
                    this.executeCommand((Command)new DeleteWithCommand(with));
                }
            }
        });
    }

    private static void configureTableLayout(Table tableWith) {
        TableColumn column1 = new TableColumn(tableWith, 16384);
        column1.setText(FordiacMessages.Event);
        TableColumn column2 = new TableColumn(tableWith, 16384);
        column2.setText(FordiacMessages.DataType);
        TableColumn column3 = new TableColumn(tableWith, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        tableWith.setLayout((Layout)layout);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.eventComposite.setVisible(!(this.getType().eContainer().eContainer() instanceof SubAppType));
        if (this.commandStack == null) {
            this.arraySizeText.setEnabled(false);
            this.initValueText.setEnabled(false);
            this.withEventsViewer.setInput(null);
            Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setGrayed(true));
        }
    }

    protected VarDeclaration getType() {
        return (VarDeclaration)super.getType();
    }

    @Override
    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.arraySizeText.setText(this.getType().getArraySize() <= 0 ? "" : Integer.toString(this.getType().getArraySize()));
            this.initValueText.setText(this.getType().getValue() == null ? "" : this.getType().getValue().getValue());
            if (this.getType().eContainer().eContainer() instanceof FBType) {
                this.eventComposite.setVisible(true);
                this.withEventsViewer.setInput((Object)this.getType());
                Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setChecked(false));
                this.getType().getWiths().stream().map(with -> this.withEventsViewer.testFindItem((Object)with.eContainer())).filter(item -> item instanceof TableItem).forEach(item -> ((TableItem)item).setChecked(true));
            } else {
                this.eventComposite.setVisible(false);
            }
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    protected Collection<DataType> getTypes() {
        return DataTypeLibrary.getInstance().getDataTypesSorted();
    }
}

