/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyEditPartsAction;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CutEditPartsAction
extends CopyEditPartsAction {
    public CutEditPartsAction(IEditorPart editor) {
        super(editor);
        this.setId(ActionFactory.CUT.getId());
        this.setText(Messages.CutEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
    }

    @Override
    public void run() {
        List<Object> templates = this.getSelectedTemplates();
        this.execute(CutEditPartsAction.getFBDeleteCommands(templates));
        templates.add(this.getWorkbenchPart().getAdapter(FBNetwork.class));
        Clipboard.getDefault().setContents(templates);
    }

    private static Command getFBDeleteCommands(List<Object> templates) {
        CompoundCommand cmd = new CompoundCommand();
        for (Object obj : templates) {
            if (!(obj instanceof FBNetworkElement)) continue;
            cmd.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)obj));
        }
        return cmd;
    }
}

