/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.actions.MapAction;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MapToContributionItem
extends ContributionItem {
    public IMenuListener mapToListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            MapToContributionItem.this.createDeviceMenu(manager);
        }
    };

    public MapToContributionItem() {
    }

    public MapToContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((IMenuManager)this.getParent()).addMenuListener(this.mapToListener);
            ((IMenuManager)this.getParent()).setRemoveAllWhenShown(true);
        }
        this.createDeviceMenu((IMenuManager)this.getParent());
    }

    private void createDeviceMenu(IMenuManager maptoMenu) {
        FBNetworkEditor fbEditor;
        EList devices;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (this.isFBorSubAppSelected(selection) && activeEditor instanceof FBNetworkEditor && !(devices = (fbEditor = (FBNetworkEditor)activeEditor).getSystem().getSystemConfiguration().getDevices()).isEmpty()) {
            for (Device device : devices) {
                this.createDeviceMenuEntry(maptoMenu, device);
            }
        }
    }

    private boolean isFBorSubAppSelected(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof AbstractFBNElementEditPart || element instanceof SubAppForFBNetworkEditPart) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void createDeviceMenuEntry(IMenuManager maptoMenu, Device device) {
        MenuManager deviceMenu = new MenuManager();
        deviceMenu.setMenuText(device.getName() == null ? FordiacMessages.Device : device.getName());
        deviceMenu.setImageDescriptor(FordiacImage.ICON_DEVICE.getImageDescriptor());
        maptoMenu.add((IContributionItem)deviceMenu);
        deviceMenu.fill(((MenuManager)maptoMenu).getMenu(), -1);
        deviceMenu.setRemoveAllWhenShown(true);
        this.createResourceMenu(deviceMenu, device);
    }

    private void createResourceMenu(final MenuManager parentMenuManager, final Device device) {
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EList resources = device.getResource();
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                for (Resource resource : resources) {
                    MapAction action = new MapAction((IWorkbenchPart)activeEditor, resource);
                    action.setText(resource.getName() == null ? FordiacMessages.Resource : resource.getName());
                    action.setImageDescriptor(FordiacImage.ICON_RESOURCE.getImageDescriptor());
                    parentMenuManager.add((IAction)action);
                }
            }
        };
        parentMenuManager.addMenuListener(listener);
    }
}

