/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public abstract class AbstractCodeMetricAnalyzer {
    public void calculateMetrics(INamedElement element) {
        if (element instanceof Application) {
            this.analyzeFBNetwork(((Application)element).getFBNetwork());
        } else if (element instanceof SubApp) {
            this.analyzeSubApp((SubApp)element);
        } else if (element instanceof FBType) {
            this.analyzeFBType((FBType)element);
        }
    }

    public abstract List<MetricData> getResults();

    private void analyzeFBNetwork(FBNetwork fbNetwork) {
        for (FBNetworkElement fb : fbNetwork.getNetworkElements()) {
            if (fb instanceof SubApp) {
                this.analyzeSubApp((SubApp)fb);
                continue;
            }
            this.analyzeFBType(fb.getType());
        }
    }

    private void analyzeSubApp(SubApp subApp) {
        this.analyzeFBNetwork(subApp.getType() != null ? subApp.getType().getFBNetwork() : subApp.getSubAppNetwork());
    }

    private void analyzeFBType(FBType type) {
        if (type instanceof BasicFBType) {
            this.analyzeBFB((BasicFBType)type);
        } else if (type instanceof CompositeFBType) {
            this.analyzeFBNetwork(((CompositeFBType)type).getFBNetwork());
        }
    }

    protected abstract void analyzeBFB(BasicFBType var1);
}

