/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class DeleteFBTypeParticipant
extends DeleteParticipant {
    protected boolean initialize(Object element) {
        return element instanceof IFile;
    }

    public String getName() {
        return Messages.DeleteFBTypeParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceChangeChecker resChecker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = resChecker.getDeltaFactory();
        IResourceDelta[] affectedChildren = deltaFactory.getDelta().getAffectedChildren();
        return DeleteFBTypeParticipant.verifyAffectedChildren(affectedChildren);
    }

    private static RefactoringStatus verifyAffectedChildren(IResourceDelta[] affectedChildren) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            if (resourceDelta.getResource() instanceof IFile) {
                String typeNameToDelete;
                Palette palette = SystemManager.INSTANCE.getPalette(resourceDelta.getResource().getProject());
                List<String> typeNames = DeleteFBTypeParticipant.checkTypeContainment(palette, typeNameToDelete = TypeLibrary.getTypeNameFromFile((IFile)((IFile)resourceDelta.getResource())));
                if (!typeNames.isEmpty()) {
                    return RefactoringStatus.createWarningStatus((String)MessageFormat.format(Messages.DeleteFBTypeParticipant_TypeInUseWarning, typeNameToDelete, typeNames.toString()));
                }
            } else {
                return DeleteFBTypeParticipant.verifyAffectedChildren(resourceDelta.getAffectedChildren());
            }
            ++n2;
        }
        return new RefactoringStatus();
    }

    private static List<String> checkTypeContainment(Palette palette, String searchTypeName) {
        ArrayList<String> retVal = new ArrayList<String>();
        Stream stream = Stream.concat(Stream.concat(palette.getFbTypes().entrySet().stream(), palette.getSubAppTypes().entrySet().stream()), palette.getResourceTypes().entrySet().stream());
        stream.forEach(entry -> {
            FBNetwork network = DeleteFBTypeParticipant.getNetwork(entry);
            if (network != null && DeleteFBTypeParticipant.containsElementWithType(searchTypeName, network)) {
                retVal.add(((PaletteEntry)entry.getValue()).getLabel());
            }
        });
        return retVal;
    }

    private static FBNetwork getNetwork(Map.Entry<String, ? extends PaletteEntry> entry) {
        FBNetwork network = null;
        LibraryElement type = entry.getValue().getType();
        if (type instanceof CompositeFBType) {
            network = ((CompositeFBType)type).getFBNetwork();
        } else if (type instanceof ResourceType) {
            network = ((ResourceType)type).getFBNetwork();
        } else if (type instanceof SubAppType) {
            network = ((SubAppType)type).getFBNetwork();
        }
        return network;
    }

    private static boolean containsElementWithType(String searchTypeName, FBNetwork network) {
        for (FBNetworkElement element : network.getNetworkElements()) {
            if (!searchTypeName.equals(element.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

