/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPartFactory;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class ServiceSequenceEditor
extends GraphicalEditorWithFlyoutPalette
implements IFBTEditorPart {
    private FBType fbType;
    private KeyHandler sharedKeyHandler;
    private CommandStack commandStack;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInputWithNotify(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.fbType = untypedInput.getContent();
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
        this.setPartName(Messages.ServiceSequenceEditor_Service);
        this.setTitleImage(FordiacImage.ICON_SERVICE_SEQUENCE.getImage());
        super.init(site, input);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ZoomScalableFreeformRootEditPart root = new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new ServiceSequenceEditPartFactory((GraphicalEditor)this));
        FordiacContextMenuProvider cmProvider = new FordiacContextMenuProvider((EditPartViewer)viewer, root.getZoomManager(), this.getActionRegistry()){

            public void buildContextMenu(IMenuManager menu) {
                super.buildContextMenu(menu);
                IAction action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.copy", action);
            }
        };
        viewer.setContextMenu((MenuManager)cmProvider);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        KeyHandler viewerKeyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(viewerKeyHandler);
    }

    public void createPartControl(Composite parent) {
        Composite graphicaEditor = new Composite(parent, 0);
        graphicaEditor.setLayout((Layout)new FillLayout());
        super.createPartControl(graphicaEditor);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.fbType);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        }
        return this.sharedKeyHandler;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (part.getSite().getPage().getActiveEditor() instanceof FBTypeEditor) {
            this.updateActions(this.getSelectionActions());
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.getFirstElement() instanceof SequenceRootEditPart) {
                    ((FBType)((SequenceRootEditPart)((Object)sel.getFirstElement())).getModel()).getService();
                } else if (sel.getFirstElement() instanceof OutputPrimitiveEditPart) {
                    ((OutputPrimitiveEditPart)((Object)sel.getFirstElement())).getModel();
                } else if (sel.getFirstElement() instanceof InputPrimitiveEditPart) {
                    ((InputPrimitiveEditPart)((Object)sel.getFirstElement())).getModel();
                }
            }
        }
    }

    protected PaletteRoot getPaletteRoot() {
        return ServiceInterfacePaletteFactory.createPalette();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        if (selectedElement != null) {
            Object editpart = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
            this.getGraphicalViewer().flush();
            if (editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
                this.getGraphicalViewer().select((EditPart)editpart);
                return true;
            }
            if (selectedElement instanceof Service) {
                return true;
            }
        }
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }
}

