/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;

public final class IdentifierVerifyer {
    private static final String IDENTIFIER_REGEX = "[_A-Za-z][_A-Za-z\\d]*";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[_A-Za-z][_A-Za-z\\d]*", 8);
    private static final String INVALID_IDENTIFIER_REGEX = "[^_A-Za-z\\d]";
    private static final Pattern INVALID_IDENTIFIER_PATTERN = Pattern.compile("[^_A-Za-z\\d]", 8);

    private IdentifierVerifyer() {
    }

    public static boolean isValidIdentifier(String identifier) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(identifier);
        return matcher.matches();
    }

    public static String isValidIdentifierWithErrorMessage(String identifier) {
        if (IdentifierVerifyer.isValidIdentifier(identifier)) {
            return null;
        }
        if (identifier.length() < 1) {
            return Messages.IdentifierVerifyer_ERROR_IdentifierLengthZero;
        }
        String firstChar = identifier.substring(0, 1);
        Matcher startSymbolMatcher = IDENTIFIER_PATTERN.matcher(firstChar);
        if (!startSymbolMatcher.matches()) {
            return Messages.IdentifierVerifyer_ERROR_InvalidStartSymbol;
        }
        Matcher invalidExpressionSymbolsMatcher = INVALID_IDENTIFIER_PATTERN.matcher(identifier);
        if (invalidExpressionSymbolsMatcher.find()) {
            return MessageFormat.format(Messages.IdentifierVerifyer_ERROR_InvalidSymbolUsedInIdentifer, invalidExpressionSymbolsMatcher.group(0).toString());
        }
        return Messages.IdentifierVerifyer_ERROR_UnkownExpressionError;
    }
}

