/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public abstract class AbstractTypeExporter
extends CommonElementExporter {
    private final FBType type;

    AbstractTypeExporter(FBType type) {
        this.type = type;
    }

    protected AbstractTypeExporter(CommonElementExporter parent) {
        super(parent);
        this.type = null;
    }

    protected FBType getType() {
        return this.type;
    }

    public static void saveType(PaletteEntry entry) {
        AbstractTypeExporter exporter = null;
        if (entry instanceof FBTypePaletteEntry) {
            exporter = new FbtExporter((FBTypePaletteEntry)entry);
        } else if (entry instanceof AdapterTypePaletteEntry) {
            exporter = new AdapterExporter((AdapterTypePaletteEntry)entry);
        } else if (entry instanceof SubApplicationTypePaletteEntry) {
            exporter = new SubApplicationTypeExporter((SubApplicationTypePaletteEntry)entry);
        }
        if (exporter != null) {
            try {
                super.createXMLEntries();
            }
            catch (XMLStreamException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            exporter.writeToFile(entry.getFile());
            entry.setLastModificationTimestamp(entry.getFile().getModificationStamp());
        }
    }

    private void createXMLEntries() throws XMLStreamException {
        this.createNamedElementEntry(this.getType(), this.getRootTag());
        this.addCompileAbleTypeData(this.getType());
        this.addInterfaceList(this.getType().getInterfaceList());
        this.createTypeSpecificXMLEntries();
        this.addService(this.getType());
        this.addEndElement();
    }

    protected abstract String getRootTag();

    protected abstract void createTypeSpecificXMLEntries() throws XMLStreamException;

    private void addCompileAbleTypeData(CompilableType type) throws XMLStreamException {
        this.addIdentification(type);
        this.addVersionInfo(type);
        this.addCompilerInfo(type.getCompilerInfo());
    }

    private void addCompilerInfo(CompilerInfo compilerInfo) throws XMLStreamException {
        if (compilerInfo != null) {
            this.addStartElement("CompilerInfo");
            if (compilerInfo.getHeader() != null && !compilerInfo.getHeader().equals("")) {
                this.getWriter().writeAttribute("header", compilerInfo.getHeader());
            }
            if (compilerInfo.getClassdef() != null && !compilerInfo.getClassdef().equals("")) {
                this.getWriter().writeAttribute("classdef", compilerInfo.getClassdef());
            }
            for (Compiler compiler : compilerInfo.getCompiler()) {
                this.addCompiler(compiler);
            }
            this.addEndElement();
        }
    }

    private void addCompiler(Compiler compiler) throws XMLStreamException {
        this.addEmptyStartElement("Compiler");
        this.getWriter().writeAttribute("Language", compiler.getLanguage() != null ? compiler.getLanguage().getName() : "");
        this.getWriter().writeAttribute("Vendor", compiler.getVendor() != null ? compiler.getVendor() : "");
        this.getWriter().writeAttribute("Product", compiler.getProduct() != null ? compiler.getProduct() : "");
        this.getWriter().writeAttribute("Version", compiler.getVersion() != null ? compiler.getVersion() : "");
    }

    protected void addInterfaceList(InterfaceList interfaceList) throws XMLStreamException {
        this.addStartElement(this.getInterfaceListElementName());
        this.addEventList((List<Event>)interfaceList.getEventInputs(), this.getEventInputsElementName());
        this.addEventList((List<Event>)interfaceList.getEventOutputs(), this.getEventOutputsElementName());
        this.addVarList((List<VarDeclaration>)interfaceList.getInputVars(), "InputVars");
        this.addVarList((List<VarDeclaration>)interfaceList.getOutputVars(), "OutputVars");
        this.createAdapterList((List<AdapterDeclaration>)interfaceList.getPlugs(), "Plugs");
        this.createAdapterList((List<AdapterDeclaration>)interfaceList.getSockets(), "Sockets");
        this.addEndElement();
    }

    protected String getInterfaceListElementName() {
        return "InterfaceList";
    }

    private void createAdapterList(List<AdapterDeclaration> adapterList, String elementName) throws XMLStreamException {
        if (!adapterList.isEmpty()) {
            this.addStartElement(elementName);
            for (AdapterDeclaration adapter : adapterList) {
                this.addAdapterDeclaration(adapter);
            }
            this.addEndElement();
        }
    }

    private void addAdapterDeclaration(AdapterDeclaration adapterDecl) throws XMLStreamException {
        this.addEmptyStartElement("AdapterDeclaration");
        this.addNameTypeCommentAttribute(adapterDecl, adapterDecl.getType());
        if (adapterDecl.getAdapterFB() != null) {
            this.addXYAttributes(adapterDecl.getAdapterFB());
        }
    }

    protected void addVarList(List<VarDeclaration> varList, String elementName) throws XMLStreamException {
        if (!varList.isEmpty()) {
            this.addStartElement(elementName);
            for (VarDeclaration varDecl : varList) {
                if (varDecl instanceof AdapterDeclaration) continue;
                this.addVariable(varDecl);
            }
            this.addEndElement();
        }
    }

    protected void addVariable(VarDeclaration varDecl) throws XMLStreamException {
        this.addEmptyStartElement("VarDeclaration");
        this.addNameTypeCommentAttribute(varDecl, varDecl.getType());
        if (varDecl.isArray()) {
            this.getWriter().writeAttribute("ArraySize", Integer.toString(varDecl.getArraySize()));
        }
        if (varDecl.getValue() != null && varDecl.getValue().getValue() != null) {
            this.getWriter().writeAttribute("InitialValue", varDecl.getValue().getValue());
        }
    }

    private void addEventList(List<Event> eventList, String elementName) throws XMLStreamException {
        if (!eventList.isEmpty()) {
            this.addStartElement(elementName);
            for (Event event : eventList) {
                this.addEvent(event);
            }
            this.addEndElement();
        }
    }

    protected String getEventOutputsElementName() {
        return "EventOutputs";
    }

    protected String getEventInputsElementName() {
        return "EventInputs";
    }

    private void addEvent(Event event) throws XMLStreamException {
        this.addStartElement(this.getEventElementName());
        this.addNameAttribute(event.getName());
        this.getWriter().writeAttribute("Type", "Event");
        this.addCommentAttribute(event);
        this.addWith(event);
        this.addEndElement();
    }

    protected String getEventElementName() {
        return "Event";
    }

    private void addWith(Event event) throws XMLStreamException {
        for (With with : event.getWith()) {
            this.addEmptyStartElement("With");
            VarDeclaration varDecl = with.getVariables();
            this.getWriter().writeAttribute("Var", varDecl.getName() != null ? varDecl.getName() : "");
        }
    }

    private void addService(FBType sfb) throws XMLStreamException {
        if (sfb.getService() != null && sfb.getService().getRightInterface() != null && sfb.getService().getLeftInterface() != null) {
            this.addStartElement("Service");
            this.getWriter().writeAttribute("RightInterface", sfb.getService().getRightInterface().getName());
            this.getWriter().writeAttribute("LeftInterface", sfb.getService().getLeftInterface().getName());
            this.addCommentAttribute(sfb);
            this.addServiceSequences((List<ServiceSequence>)sfb.getService().getServiceSequence());
            this.addEndElement();
        }
    }

    private void addServiceSequences(List<ServiceSequence> sequences) throws XMLStreamException {
        for (ServiceSequence seq : sequences) {
            this.addStartElement("ServiceSequence");
            this.addNameAttribute(seq.getName());
            this.addCommentAttribute(seq);
            this.addServiceTransactions((List<ServiceTransaction>)seq.getServiceTransaction());
            this.addEndElement();
        }
    }

    private void addServiceTransactions(List<ServiceTransaction> transactions) throws XMLStreamException {
        for (ServiceTransaction transaction : transactions) {
            this.addStartElement("ServiceTransaction");
            if (transaction.getInputPrimitive() != null) {
                this.addPrimitive(transaction.getInputPrimitive(), "InputPrimitive");
            }
            if (!transaction.getOutputPrimitive().isEmpty()) {
                this.addOutputPrimitives(transaction);
            }
            this.addEndElement();
        }
    }

    private void addPrimitive(Primitive prim, String primNodeName) throws XMLStreamException {
        this.addEmptyStartElement(primNodeName);
        this.getWriter().writeAttribute("Interface", prim.getInterface() != null && prim.getInterface().getName() != null ? prim.getInterface().getName() : "");
        this.getWriter().writeAttribute("Event", prim.getEvent() != null ? prim.getEvent() : "");
        if (prim.getParameters() != null && !prim.getParameters().equals(" ")) {
            this.getWriter().writeAttribute("Parameters", prim.getParameters());
        }
    }

    private void addOutputPrimitives(ServiceTransaction transaction) throws XMLStreamException {
        for (OutputPrimitive primitive : transaction.getOutputPrimitive()) {
            this.addPrimitive(primitive, "OutputPrimitive");
        }
    }
}

