/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public class ImportUtils {
    private ImportUtils() {
    }

    public static AdapterEvent createAdapterEvent(Event event, AdapterDeclaration a) {
        AdapterEvent ae = LibraryElementFactory.eINSTANCE.createAdapterEvent();
        ae.setName(event.getName());
        ae.setComment(event.getComment());
        ae.setAdapterDeclaration(a);
        return ae;
    }

    public static String getSeperatorRegex() {
        String regex = File.separator;
        if (regex.equals("\\")) {
            regex = "\\\\";
        }
        return regex;
    }

    public static void copyFile(File in, File out) throws IOException {
        Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File in, IFile out) throws IOException, CoreException {
        if (!out.getParent().exists()) {
            ((IFolder)out.getParent()).create(true, true, null);
            out.getParent().refreshLocal(0, null);
        }
        Files.copy(in.toPath(), out.getLocation().toFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        try {
            out.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }
}

